/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep.adapter;

import hep.analysis.EventHeader;
import hep.io.stdhep.StdhepEvent;
import hep.physics.Particle;
import hep.physics.ParticleEnumeration;
import hep.physics.ParticleProperties;
import hep.physics.ParticleType;
import hep.physics.ParticleVector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class HepEvent
implements EventHeader {
    private StdhepEvent hepevt;
    private HepParticle[] particle;
    private Hashtable m_hash = new Hashtable();

    HepEvent(StdhepEvent stdhepEvent) {
        this.hepevt = stdhepEvent;
        this.particle = new HepParticle[stdhepEvent.getNHEP()];
        this.m_hash.put("MCParticles", new HepParticleVector());
    }

    public int getRunNumber() {
        return 0;
    }

    public int getEventNumber() {
        return this.hepevt.getNEVHEP();
    }

    public Enumeration keys() {
        return this.m_hash.keys();
    }

    public Object get(String string) {
        Object v = this.m_hash.get(string);
        if (v == null) {
            throw new RuntimeException("Unknown event component " + string);
        }
        return v;
    }

    public void put(String string, Object object) {
        this.m_hash.put(string, object);
    }

    public Properties getProperties() {
        return null;
    }

    private final class ParentEnumeration
    implements ParticleEnumeration {
        private int i = 0;
        private int n = 0;
        private int[] id = new int[2];

        ParentEnumeration(int n, int n2) {
            if (n != 0) {
                this.id[this.n++] = n - 1;
            }
            if (n2 != 0) {
                this.id[this.n++] = n2 - 1;
            }
        }

        public boolean hasMoreElements() {
            return this.i < this.n;
        }

        public boolean hasMoreParticles() {
            return this.i < this.n;
        }

        public Object nextElement() {
            return this.nextParticle();
        }

        public Particle nextParticle() {
            int n = this.id[this.i++];
            if (HepEvent.this.particle[n] == null) {
                ((HepEvent)HepEvent.this).particle[n] = new HepParticle(n);
            }
            return HepEvent.this.particle[n];
        }
    }

    private final class HepEnumeration
    implements ParticleEnumeration {
        private int i;
        private int n;

        HepEnumeration() {
            this.i = 0;
            this.n = HepEvent.this.hepevt.getNHEP();
        }

        HepEnumeration(int n, int n2) {
            this.i = n - 1;
            this.n = n == 0 ? -1 : n2;
        }

        public boolean hasMoreElements() {
            return this.i < this.n;
        }

        public boolean hasMoreParticles() {
            return this.i < this.n;
        }

        public Object nextElement() {
            return this.nextParticle();
        }

        public Particle nextParticle() {
            if (HepEvent.this.particle[this.i] == null) {
                ((HepEvent)HepEvent.this).particle[this.i] = new HepParticle(this.i);
            }
            return HepEvent.this.particle[this.i++];
        }
    }

    private final class HepParticle
    implements Particle {
        private int index;

        HepParticle(int n) {
            this.index = n;
        }

        public double getPX() {
            return HepEvent.this.hepevt.getPHEP(this.index, 0);
        }

        public double getPY() {
            return HepEvent.this.hepevt.getPHEP(this.index, 1);
        }

        public double getPZ() {
            return HepEvent.this.hepevt.getPHEP(this.index, 2);
        }

        public double getEnergy() {
            return HepEvent.this.hepevt.getPHEP(this.index, 3);
        }

        public double getMass() {
            return HepEvent.this.hepevt.getPHEP(this.index, 4);
        }

        public double getOriginX() {
            return HepEvent.this.hepevt.getVHEP(this.index, 0);
        }

        public double getOriginY() {
            return HepEvent.this.hepevt.getVHEP(this.index, 1);
        }

        public double getOriginZ() {
            return HepEvent.this.hepevt.getVHEP(this.index, 2);
        }

        public double getProductionTime() {
            return HepEvent.this.hepevt.getVHEP(this.index, 3);
        }

        public int getStatusCode() {
            return HepEvent.this.hepevt.getISTHEP(this.index);
        }

        public double[] getMomentum() {
            double[] dArray = new double[]{this.getPX(), this.getPY(), this.getPZ()};
            return dArray;
        }

        public double[] getOrigin() {
            double[] dArray = new double[]{this.getOriginX(), this.getOriginY(), this.getOriginZ()};
            return dArray;
        }

        public ParticleEnumeration getDaughters() {
            return new HepEnumeration(HepEvent.this.hepevt.getJDAHEP(this.index, 0), HepEvent.this.hepevt.getJDAHEP(this.index, 1));
        }

        public Particle getParent() {
            int n = HepEvent.this.hepevt.getJMOHEP(this.index, 0);
            int n2 = HepEvent.this.hepevt.getJMOHEP(this.index, 1);
            if (n == 0) {
                return null;
            }
            if (n2 != 0) {
                throw new RuntimeException(">1 parent, use getParents() instead of getParent()");
            }
            if (HepEvent.this.particle[--n] == null) {
                ((HepEvent)HepEvent.this).particle[n] = new HepParticle(n);
            }
            return HepEvent.this.particle[n];
        }

        public ParticleEnumeration getParents() {
            return new ParentEnumeration(HepEvent.this.hepevt.getJMOHEP(this.index, 0), HepEvent.this.hepevt.getJMOHEP(this.index, 1));
        }

        public ParticleType getType() {
            return ParticleProperties.get(HepEvent.this.hepevt.getIDHEP(this.index));
        }
    }

    private class HepParticleVector
    implements ParticleVector {
        private HepParticleVector() {
        }

        public int size() {
            return HepEvent.this.hepevt.getNHEP();
        }

        public ParticleEnumeration particles() {
            return new HepEnumeration();
        }
    }
}

