/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOWriter;
import hep.io.stdhep.StdhepConstants;
import hep.io.stdhep.StdhepEvent;
import hep.io.stdhep.StdhepReader;
import hep.io.stdhep.StdhepRecord;
import java.io.IOException;

public class StdhepWriter
extends MCFIOWriter
implements StdhepConstants {
    private static int[] blockIds = new int[]{101, 105, 106, 107};
    private static String[] blockNames = new String[]{"Stdhep Event", "Stdhep Multi", "Stdhep Begin Run", "Stdhep End Run"};
    private MCFIOEventWrapper event = new MCFIOEventWrapper();

    public StdhepWriter(String string, String string2, String string3, int n) throws IOException {
        super(string, string2, string3, n, blockIds, blockNames);
    }

    public void writeRecord(StdhepRecord stdhepRecord) throws IOException {
        if (MCFIOWriter.compatibilityMode && stdhepRecord instanceof StdhepEvent && ((StdhepEvent)stdhepRecord).getNHEP() > 4000) {
            throw new IOException("Too many particles");
        }
        this.event.setRecord(stdhepRecord);
        this.write(this.event);
    }

    public static void main(String[] stringArray) throws Exception {
        StdhepReader stdhepReader = new StdhepReader("c:\\temp\\pybms-ZZ-500-990115-gen-98.dat");
        StdhepWriter stdhepWriter = new StdhepWriter("test.stdhep", stdhepReader.getTitle(), stdhepReader.getComment(), stdhepReader.getNumberOfEvents());
        try {
            while (true) {
                StdhepRecord stdhepRecord = stdhepReader.nextRecord();
                System.out.println("record=" + stdhepRecord);
                stdhepWriter.writeRecord(stdhepRecord);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stdhepWriter.close();
            stdhepReader.close();
            throw throwable;
        }
    }

    private class MCFIOEventWrapper
    implements MCFIOEvent {
        private StdhepRecord record;

        private MCFIOEventWrapper() {
        }

        public int getRunNumber() {
            return 0;
        }

        public int getEventNumber() {
            if (this.record instanceof StdhepEvent) {
                return ((StdhepEvent)this.record).getNEVHEP();
            }
            return 0;
        }

        public int getStoreNumber() {
            return 0;
        }

        public int getTrigMask() {
            return 0;
        }

        public int getNBlocks() {
            return 1;
        }

        public int getBlockID(int n) {
            return this.record.getID();
        }

        public MCFIOBlock getBlock(int n) {
            return this.record;
        }

        void setRecord(StdhepRecord stdhepRecord) throws IOException {
            this.record = stdhepRecord;
        }
    }
}

