/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOReader;
import hep.io.stdhep.StdhepBeginRun;
import hep.io.stdhep.StdhepConstants;
import hep.io.stdhep.StdhepEndRun;
import hep.io.stdhep.StdhepEvent;
import hep.io.stdhep.StdhepRecord;
import java.io.IOException;

public class StdhepReader
extends MCFIOReader
implements StdhepConstants {
    public StdhepReader(String string) throws IOException {
        super(string);
    }

    public StdhepRecord nextRecord() throws IOException {
        MCFIOEvent mCFIOEvent;
        int n;
        while ((n = (mCFIOEvent = super.nextEvent()).getNBlocks()) == 0) {
        }
        if (n != 1) {
            throw new IOException("Invalid stdhep record found (NBlocks=" + n + ")");
        }
        return (StdhepRecord)mCFIOEvent.getBlock(0);
    }

    protected MCFIOBlock createUserBlock(int n) throws IOException {
        switch (n) {
            case 101: {
                return new StdhepEvent();
            }
            case 106: {
                return new StdhepBeginRun();
            }
            case 107: {
                return new StdhepEndRun();
            }
        }
        return super.createUserBlock(n);
    }

    public static void main(String[] stringArray) throws Exception {
        StdhepReader stdhepReader = new StdhepReader(stringArray[0]);
        System.out.println("title - " + stdhepReader.getTitle());
        System.out.println("comment - " + stdhepReader.getComment());
        try {
            int n = 0;
            while (true) {
                StdhepRecord stdhepRecord;
                if ((stdhepRecord = stdhepReader.nextRecord()) instanceof StdhepEvent) {
                    StdhepEvent stdhepEvent = (StdhepEvent)stdhepRecord;
                    System.out.println("-------------Event " + stdhepEvent.getNEVHEP());
                    int n2 = 0;
                    while (n2 < stdhepEvent.getNHEP()) {
                        System.out.println(n2 + ": " + stdhepEvent.getJMOHEP(n2, 0) + " " + stdhepEvent.getJMOHEP(n2, 1) + " " + stdhepEvent.getJDAHEP(n2, 0) + " " + stdhepEvent.getJDAHEP(n2, 1));
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            stdhepReader.close();
            throw throwable;
        }
    }
}

