/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep;

import hep.io.stdhep.StdhepRecord;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import java.io.IOException;

public class StdhepEvent
extends StdhepRecord {
    private int nevhep;
    private int nhep;
    private int[] isthep;
    private int[] idhep;
    private int[] jmohep;
    private int[] jdahep;
    private double[] phep;
    private double[] vhep;

    StdhepEvent() {
        super(101);
    }

    public StdhepEvent(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray, double[] dArray2) {
        super(101);
        this.version = "3.01";
        this.length = 4 * (12 + 24 * n2);
        this.nevhep = n;
        this.nhep = n2;
        this.isthep = nArray;
        this.idhep = nArray2;
        this.jmohep = nArray3;
        this.jdahep = nArray4;
        this.phep = dArray;
        this.vhep = dArray2;
    }

    public void read(XDRDataInput xDRDataInput) throws IOException {
        super.read(xDRDataInput);
        this.nevhep = xDRDataInput.readInt();
        this.nhep = xDRDataInput.readInt();
        this.isthep = xDRDataInput.readIntArray(this.isthep);
        this.idhep = xDRDataInput.readIntArray(this.idhep);
        this.jmohep = xDRDataInput.readIntArray(this.jmohep);
        this.jdahep = xDRDataInput.readIntArray(this.jdahep);
        this.phep = xDRDataInput.readDoubleArray(this.phep);
        this.vhep = xDRDataInput.readDoubleArray(this.vhep);
    }

    public void write(XDRDataOutput xDRDataOutput) throws IOException {
        super.write(xDRDataOutput);
        xDRDataOutput.writeInt(this.nevhep);
        xDRDataOutput.writeInt(this.nhep);
        xDRDataOutput.writeIntArray(this.isthep, 0, this.nhep);
        xDRDataOutput.writeIntArray(this.idhep, 0, this.nhep);
        xDRDataOutput.writeIntArray(this.jmohep, 0, 2 * this.nhep);
        xDRDataOutput.writeIntArray(this.jdahep, 0, 2 * this.nhep);
        xDRDataOutput.writeDoubleArray(this.phep, 0, 5 * this.nhep);
        xDRDataOutput.writeDoubleArray(this.vhep, 0, 4 * this.nhep);
    }

    public int getNEVHEP() {
        return this.nevhep;
    }

    public int getNHEP() {
        return this.nhep;
    }

    public int getISTHEP(int n) {
        return this.isthep[n];
    }

    public int getIDHEP(int n) {
        return this.idhep[n];
    }

    public int getJMOHEP(int n, int n2) {
        return this.jmohep[n * 2 + n2];
    }

    public int getJDAHEP(int n, int n2) {
        return this.jdahep[n * 2 + n2];
    }

    public double getPHEP(int n, int n2) {
        return this.phep[n * 5 + n2];
    }

    public double getVHEP(int n, int n2) {
        return this.vhep[n * 4 + n2];
    }

    public String toString() {
        return "Event " + this.nevhep + " particles=" + this.nhep;
    }
}

