/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.BufferedRandomAccessFile;
import hep.io.mcfio.EventTable;
import hep.io.mcfio.FileHeader;
import hep.io.mcfio.MCFIOConstants;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRRandomAccessFile;
import java.io.IOException;

public class MCFIOWriter
implements MCFIOConstants {
    private WriteEventTable eventTable;
    private FileHeader fileHeader;
    private XDRRandomAccessFile xdr;
    protected static boolean compatibilityMode = true;

    public MCFIOWriter(String string, String string2, String string3, int n, int[] nArray, String[] stringArray) throws IOException {
        if (compatibilityMode) {
            if (string2.length() > 255) {
                throw new MCFIOException("Title too long");
            }
            if (string3.length() > 255) {
                throw new MCFIOException("Comment too long");
            }
        }
        this.xdr = new BufferedRandomAccessFile(string);
        this.fileHeader = new FileHeader(this.getPosition(), string2, string3, n, nArray, stringArray);
        this.xdr.seek(this.fileHeader.getLength());
        this.fileHeader.setFirstTable(this.getPosition());
        this.eventTable = new WriteEventTable(this.getPosition());
        this.xdr.seek(this.getPosition() + this.eventTable.getLength());
    }

    public void close() throws IOException {
        this.eventTable.commit(this.xdr);
        this.fileHeader.commit(this.xdr);
        this.xdr.close();
    }

    public void write(MCFIOEvent mCFIOEvent) throws IOException {
        if (this.eventTable.isFull()) {
            this.eventTable = this.eventTable.newTable();
        }
        this.eventTable.add(mCFIOEvent);
    }

    public void setCompatibilityMode(boolean bl) {
        compatibilityMode = bl;
    }

    private int getPosition() throws IOException {
        return (int)this.xdr.getFilePointer();
    }

    private class WriteEventTable
    extends EventTable {
        WriteEventTable(int n) throws IOException {
            super(n);
        }

        WriteEventTable newTable() throws IOException {
            int n = MCFIOWriter.this.getPosition();
            this.setNextTable(n);
            this.commit(MCFIOWriter.this.xdr);
            MCFIOWriter.this.xdr.seek(n + this.getLength());
            return new WriteEventTable(n);
        }

        void commit(XDRRandomAccessFile xDRRandomAccessFile) throws IOException {
            MCFIOWriter.this.fileHeader.incrementNumEvents(this.numevts());
            super.commit(xDRRandomAccessFile);
        }

        void add(MCFIOEvent mCFIOEvent) throws IOException {
            super.add(mCFIOEvent, MCFIOWriter.this.getPosition());
            int n = mCFIOEvent.getNBlocks();
            int n2 = 4 * (12 + n * 2);
            MCFIOWriter.this.xdr.writeInt(4);
            MCFIOWriter.this.xdr.writeInt(n2);
            MCFIOWriter.this.xdr.writeString("1.00");
            MCFIOWriter.this.xdr.writeInt(mCFIOEvent.getEventNumber());
            MCFIOWriter.this.xdr.writeInt(mCFIOEvent.getStoreNumber());
            MCFIOWriter.this.xdr.writeInt(mCFIOEvent.getRunNumber());
            MCFIOWriter.this.xdr.writeInt(mCFIOEvent.getTrigMask());
            MCFIOWriter.this.xdr.writeInt(n);
            MCFIOWriter.this.xdr.writeInt(n);
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n3 = MCFIOWriter.this.getPosition() + 4 * (2 + n * 2);
            int n4 = 0;
            while (n4 < n) {
                nArray2[n4] = mCFIOEvent.getBlockID(n4);
                nArray[n4] = n3;
                n3 += mCFIOEvent.getBlock(n4).getLength();
                ++n4;
            }
            MCFIOWriter.this.xdr.writeIntArray(nArray2);
            MCFIOWriter.this.xdr.writeIntArray(nArray);
            int n5 = 0;
            while (n5 < n) {
                mCFIOEvent.getBlock(n5).write(MCFIOWriter.this.xdr);
                ++n5;
            }
        }
    }
}

