/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.EventTable;
import hep.io.mcfio.FileHeader;
import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOConstants;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class MCFIOReader
implements MCFIOConstants {
    private FileHeader fileHeader;
    private EventTable eventTable;
    private int currentEvent;
    private XDRDataInput xdr;
    private String file;

    public MCFIOReader(String string) throws IOException {
        this.file = string;
        this.init(new XDRInputStream(new FileInputStream(string)));
    }

    public MCFIOReader(InputStream inputStream) throws IOException {
        this.init(new XDRInputStream(inputStream));
    }

    private void init(XDRDataInput xDRDataInput) throws IOException {
        this.xdr = xDRDataInput;
        this.fileHeader = new FileHeader();
        this.fileHeader.read(xDRDataInput);
        this.eventTable = new EventTable();
        this.eventTable.read(xDRDataInput);
        this.currentEvent = 0;
    }

    public void close() throws IOException {
        if (this.xdr instanceof RandomAccessFile) {
            ((RandomAccessFile)((Object)this.xdr)).close();
        } else {
            ((InputStream)((Object)this.xdr)).close();
        }
        this.fileHeader = null;
        this.eventTable = null;
    }

    public void rewind() throws IOException {
        if (this.file == null) {
            throw new IOException("Rewind not supported");
        }
        this.close();
        this.init(new XDRInputStream(new FileInputStream(this.file)));
    }

    public MCFIOEvent nextEvent() throws IOException {
        if (this.currentEvent >= this.eventTable.numevts()) {
            int n = this.eventTable.nextTable();
            if (n <= 0) {
                throw new EOFException();
            }
            this.skipTo(n);
            this.eventTable.read(this.xdr);
            this.currentEvent = 0;
        }
        return new EventHeader(this.currentEvent++);
    }

    protected MCFIOBlock createUserBlock(int n) throws IOException {
        throw new IOException("Unknown user block " + n);
    }

    private void skipTo(int n) throws IOException {
        if (this.xdr instanceof RandomAccessFile) {
            RandomAccessFile randomAccessFile = (RandomAccessFile)((Object)this.xdr);
            randomAccessFile.seek(n);
        } else {
            XDRInputStream xDRInputStream = (XDRInputStream)this.xdr;
            int n2 = (int)xDRInputStream.getBytesRead();
            if (n2 < n) {
                xDRInputStream.skipBytes(n - n2);
            } else if (n2 > n) {
                throw new MCFIOException("Cannot skip backwards in sequential file: " + n2 + " " + n);
            }
        }
    }

    public String getTitle() {
        return this.fileHeader.getTitle();
    }

    public String getComment() {
        return this.fileHeader.getComment();
    }

    public String getDate() {
        return this.fileHeader.getDate();
    }

    public int getNumberOfEvents() {
        return this.fileHeader.getNumberOfEvents();
    }

    public int getNumberOfEventsExpected() {
        return this.fileHeader.getNumberOfEventsExpected();
    }

    private class EventHeader
    extends MCFIOBlock
    implements MCFIOEvent {
        private boolean haveRead = false;
        private int pointer;
        private int nBlocks;
        private int[] blockIds;
        private int[] blockPtrs;
        private int evtnum;
        private int storenum;
        private int runnum;
        private int trigMask;

        EventHeader(int n) throws IOException {
            super(4);
            this.evtnum = MCFIOReader.this.eventTable.evtnum(n);
            this.runnum = MCFIOReader.this.eventTable.runnum(n);
            this.storenum = MCFIOReader.this.eventTable.storenum(n);
            this.trigMask = MCFIOReader.this.eventTable.trigMask(n);
            this.pointer = MCFIOReader.this.eventTable.ptrEvent(n);
        }

        public void read(XDRDataInput xDRDataInput) throws IOException {
            int n;
            super.read(xDRDataInput);
            if (this.fVersion > 2.0) {
                throw new MCFIOException("Unsupported version " + this.version + " for EventHeader");
            }
            this.evtnum = xDRDataInput.readInt();
            this.storenum = xDRDataInput.readInt();
            this.runnum = xDRDataInput.readInt();
            this.trigMask = xDRDataInput.readInt();
            this.nBlocks = xDRDataInput.readInt();
            int n2 = xDRDataInput.readInt();
            if (this.fVersion >= 2.0) {
                n = xDRDataInput.readInt();
                int n3 = xDRDataInput.readInt();
                if (n > 0) {
                    throw new IOException("NTuples not supported");
                }
            }
            this.blockIds = xDRDataInput.readIntArray(null);
            this.blockPtrs = xDRDataInput.readIntArray(null);
            n = 0;
            while (n < this.nBlocks) {
                if (this.blockPtrs[n] == 0) {
                    this.nBlocks = n;
                }
                ++n;
            }
        }

        private void readEvent() throws IOException {
            MCFIOReader.this.skipTo(this.pointer);
            this.read(MCFIOReader.this.xdr);
            this.haveRead = true;
        }

        public int getNBlocks() throws IOException {
            if (!this.haveRead) {
                this.readEvent();
            }
            return this.nBlocks;
        }

        public int getBlockID(int n) throws IOException {
            if (!this.haveRead) {
                this.readEvent();
            }
            return this.blockIds[n];
        }

        public MCFIOBlock getBlock(int n) throws IOException {
            if (!this.haveRead) {
                this.readEvent();
            }
            MCFIOReader.this.skipTo(this.blockPtrs[n]);
            MCFIOBlock mCFIOBlock = MCFIOReader.this.createUserBlock(this.blockIds[n]);
            mCFIOBlock.read(MCFIOReader.this.xdr);
            return mCFIOBlock;
        }

        public int getRunNumber() {
            return this.runnum;
        }

        public int getEventNumber() {
            return this.evtnum;
        }

        public int getStoreNumber() {
            return this.storenum;
        }

        public int getTrigMask() {
            return this.trigMask;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Run ");
            stringBuffer.append(this.runnum);
            stringBuffer.append(" store ");
            stringBuffer.append(this.storenum);
            stringBuffer.append(" event ");
            stringBuffer.append(this.evtnum);
            stringBuffer.append(" mask ");
            stringBuffer.append(this.trigMask);
            if (this.haveRead) {
                stringBuffer.append(" blocks [");
                int n = 0;
                while (true) {
                    stringBuffer.append(this.blockIds[n]);
                    if (++n == this.nBlocks) break;
                    stringBuffer.append(",");
                }
                stringBuffer.append("]");
            }
            return stringBuffer.toString();
        }
    }
}

