/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import hep.io.xdr.XDRSerializable;
import java.io.IOException;

public abstract class MCFIOBlock
implements XDRSerializable {
    protected int id;
    protected int length;
    protected String version;
    protected double fVersion;

    protected MCFIOBlock(int n) {
        this.id = n;
    }

    public void read(XDRDataInput xDRDataInput) throws IOException {
        int n = xDRDataInput.readInt();
        if (this.id != n) {
            throw new MCFIOException("Block error, expected " + this.id + " got " + n);
        }
        this.length = xDRDataInput.readInt();
        this.version = xDRDataInput.readString();
        try {
            this.fVersion = Double.parseDouble(this.version);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid version " + this.version);
        }
    }

    public void write(XDRDataOutput xDRDataOutput) throws IOException {
        xDRDataOutput.writeInt(this.id);
        xDRDataOutput.writeInt(this.getLength());
        xDRDataOutput.writeString(this.version);
    }

    protected int getLength() {
        return this.length;
    }
}

