/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOConstants;
import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import hep.io.xdr.XDRRandomAccessFile;
import java.io.IOException;
import java.util.Date;

class FileHeader
extends MCFIOBlock
implements MCFIOConstants {
    private String title;
    private String comment;
    private String date;
    private String closingDate;
    private int numevts;
    private int numevts_expect;
    private int firsttable;
    private int location;
    private int[] blockIds;
    private String[] blockNames;

    FileHeader() throws IOException {
        super(1);
    }

    FileHeader(int n, String string, String string2, int n2, int[] nArray, String[] stringArray) throws IOException {
        super(1);
        this.version = "1.00";
        if (nArray.length != stringArray.length) {
            throw new IllegalArgumentException("Inconsistent length got blockIds,blockNames");
        }
        this.location = n;
        this.title = string;
        this.comment = string2;
        this.numevts_expect = n2;
        this.numevts = 0;
        this.date = new Date().toString();
        this.blockIds = nArray;
        this.blockNames = stringArray;
    }

    public void read(XDRDataInput xDRDataInput) throws IOException {
        int n;
        super.read(xDRDataInput);
        if (this.fVersion > 2.01) {
            throw new MCFIOException("Unsupported version " + this.version + " for FileHeader");
        }
        this.title = xDRDataInput.readString();
        this.comment = xDRDataInput.readString();
        this.date = xDRDataInput.readString();
        this.closingDate = this.fVersion <= 2.0 ? this.date : xDRDataInput.readString();
        this.numevts_expect = xDRDataInput.readInt();
        this.numevts = xDRDataInput.readInt();
        this.firsttable = xDRDataInput.readInt();
        int n2 = xDRDataInput.readInt();
        int n3 = xDRDataInput.readInt();
        int n4 = n = this.fVersion >= 2.0 ? xDRDataInput.readInt() : 0;
        if (n > 0) {
            throw new IOException("NTuples not supported");
        }
        this.blockIds = xDRDataInput.readIntArray(this.blockIds);
        this.blockNames = new String[n3];
        int n5 = 0;
        while (n5 < n3) {
            this.blockNames[n5] = xDRDataInput.readString();
            ++n5;
        }
    }

    public void write(XDRDataOutput xDRDataOutput) throws IOException {
        super.write(xDRDataOutput);
        xDRDataOutput.writeString(this.title);
        xDRDataOutput.writeString(this.comment);
        xDRDataOutput.writeString(this.date);
        xDRDataOutput.writeInt(this.numevts_expect);
        xDRDataOutput.writeInt(this.numevts);
        xDRDataOutput.writeInt(this.firsttable);
        xDRDataOutput.writeInt(100);
        xDRDataOutput.writeInt(this.blockIds.length);
        xDRDataOutput.writeIntArray(this.blockIds);
        int n = 0;
        while (n < this.blockIds.length) {
            xDRDataOutput.writeString(this.blockNames[n]);
            ++n;
        }
    }

    void commit(XDRRandomAccessFile xDRRandomAccessFile) throws IOException {
        long l = xDRRandomAccessFile.getFilePointer();
        xDRRandomAccessFile.seek(this.location);
        this.write(xDRRandomAccessFile);
        xDRRandomAccessFile.seek(l);
    }

    protected int getLength() {
        int n = 4 * (10 + this.blockIds.length);
        n += this.strlen(this.title);
        n += this.strlen(this.comment);
        n += this.strlen(this.date);
        int n2 = 0;
        while (n2 < this.blockNames.length) {
            n += this.strlen(this.blockNames[n2]);
            ++n2;
        }
        return n;
    }

    private int strlen(String string) {
        int n = string.length();
        if (n % 4 != 0) {
            n += 4 - n % 4;
        }
        return n + 4;
    }

    String getTitle() {
        return this.title;
    }

    String getComment() {
        return this.comment;
    }

    String getDate() {
        return this.date;
    }

    int getNumberOfEvents() {
        return this.numevts;
    }

    int getNumberOfEventsExpected() {
        return this.numevts_expect;
    }

    int getFirstTable() {
        return this.firsttable;
    }

    void setFirstTable(int n) {
        this.firsttable = n;
    }

    void incrementNumEvents(int n) {
        this.numevts += n;
    }
}

