/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOConstants;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import hep.io.xdr.XDRRandomAccessFile;
import java.io.IOException;

class EventTable
extends MCFIOBlock
implements MCFIOConstants {
    private int[] runnums;
    private int[] evtnums;
    private int[] storenums;
    private int[] trigMasks;
    private int[] ptrEvents;
    private int numevts;
    private int nextLocator;
    private int location;

    EventTable() throws IOException {
        super(2);
    }

    EventTable(int n) throws IOException {
        super(2);
        this.version = "1.00";
        this.location = n;
        this.nextLocator = -2;
        this.numevts = 0;
        this.runnums = new int[100];
        this.evtnums = new int[100];
        this.storenums = new int[100];
        this.trigMasks = new int[100];
        this.ptrEvents = new int[100];
    }

    public void read(XDRDataInput xDRDataInput) throws IOException {
        super.read(xDRDataInput);
        if (!this.version.equals("1.00")) {
            throw new MCFIOException("Unsupported version " + this.version + " for EventTable");
        }
        this.nextLocator = xDRDataInput.readInt();
        this.numevts = xDRDataInput.readInt();
        this.evtnums = xDRDataInput.readIntArray(this.evtnums);
        this.storenums = xDRDataInput.readIntArray(this.storenums);
        this.runnums = xDRDataInput.readIntArray(this.runnums);
        this.trigMasks = xDRDataInput.readIntArray(this.trigMasks);
        this.ptrEvents = xDRDataInput.readIntArray(this.ptrEvents);
    }

    public void write(XDRDataOutput xDRDataOutput) throws IOException {
        super.write(xDRDataOutput);
        xDRDataOutput.writeInt(this.nextLocator);
        xDRDataOutput.writeInt(this.numevts);
        xDRDataOutput.writeIntArray(this.evtnums);
        xDRDataOutput.writeIntArray(this.storenums);
        xDRDataOutput.writeIntArray(this.runnums);
        xDRDataOutput.writeIntArray(this.trigMasks);
        xDRDataOutput.writeIntArray(this.ptrEvents);
    }

    protected int getLength() {
        return 4 * (11 + this.evtnums.length * 5);
    }

    void commit(XDRRandomAccessFile xDRRandomAccessFile) throws IOException {
        long l = xDRRandomAccessFile.getFilePointer();
        xDRRandomAccessFile.seek(this.location);
        this.write(xDRRandomAccessFile);
        xDRRandomAccessFile.seek(l);
    }

    void add(MCFIOEvent mCFIOEvent, int n) throws IOException {
        this.runnums[this.numevts] = mCFIOEvent.getRunNumber();
        this.evtnums[this.numevts] = mCFIOEvent.getEventNumber();
        this.storenums[this.numevts] = mCFIOEvent.getStoreNumber();
        this.trigMasks[this.numevts] = mCFIOEvent.getTrigMask();
        this.ptrEvents[this.numevts] = n;
        ++this.numevts;
    }

    boolean isFull() {
        return this.numevts >= this.evtnums.length;
    }

    int nextTable() {
        return this.nextLocator;
    }

    void setNextTable(int n) {
        this.nextLocator = n;
    }

    int runnum(int n) {
        return this.runnums[n];
    }

    int evtnum(int n) {
        return this.evtnums[n];
    }

    int storenum(int n) {
        return this.storenums[n];
    }

    int trigMask(int n) {
        return this.trigMasks[n];
    }

    int ptrEvent(int n) {
        return this.ptrEvents[n];
    }

    int numevts() {
        return this.numevts;
    }
}

