/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.xdr.XDRRandomAccessFile;
import java.io.IOException;

class BufferedRandomAccessFile
extends XDRRandomAccessFile {
    private int offset = 0;
    private int pos = 0;
    private int used = 0;
    private byte[] buffer = new byte[8096];

    BufferedRandomAccessFile(String string) throws IOException {
        super(string, "rw");
    }

    public void flush() throws IOException {
        super.seek(this.offset);
        super.write(this.buffer, 0, this.used);
        this.offset += this.used;
        this.used = 0;
        this.pos = 0;
    }

    public void close() throws IOException {
        this.flush();
        super.close();
        this.buffer = null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer.length - this.pos <= n2) {
            System.arraycopy(byArray, n, this.buffer, this.pos, n2);
            this.pos += n2;
            if (this.pos > this.used) {
                this.used = this.pos;
            }
        } else {
            this.used = this.pos;
            this.flush();
            super.write(byArray, n, n2);
            this.offset += n2;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        if (this.pos == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)n;
        if (this.pos > this.used) {
            this.used = this.pos;
        }
    }

    public long getFilePointer() throws IOException {
        return this.offset + this.pos;
    }

    public void seek(long l) throws IOException {
        if (l >= (long)this.offset && l <= (long)(this.offset + this.used)) {
            this.pos = (int)l - this.offset;
        } else {
            this.flush();
            this.offset = (int)l;
        }
    }

    public int read() throws IOException {
        throw new IOException("Read not supported");
    }

    public int read(byte[] byArray) throws IOException {
        throw new IOException("Read not supported");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException("Read not supported");
    }
}

