/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.standalone;

import hep.analysis.EndOfDataException;
import hep.analysis.EventAnalyzer;
import hep.analysis.EventData;
import hep.analysis.EventSource;
import hep.analysis.Job;
import hep.analysis.NamedObject;
import hep.analysis.PeerSupport;
import hep.analysis.peer.JobPeer;
import hep.analysis.standalone.NoEventSourceSet;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class StandAloneJob
implements JobPeer {
    private static StandAloneJob theJob;
    private Job m_hepJob;
    private EventSource m_source;
    private Vector m_analyzer = new Vector();
    private String m_name;
    private boolean m_atStart;

    StandAloneJob(String string, Job job) {
        this.m_name = string;
        theJob = this;
        this.m_hepJob = job;
    }

    public void sendMessage(String string) {
        System.out.println(string);
    }

    public OutputStream getLogStream() {
        return System.out;
    }

    public void setEventSource(EventSource eventSource) {
        this.m_source = eventSource;
        this.m_atStart = true;
    }

    public void addEventAnalyzer(EventAnalyzer eventAnalyzer) {
        this.m_analyzer.addElement(eventAnalyzer);
    }

    public void removeEventAnalyzer(EventAnalyzer eventAnalyzer) {
        this.m_analyzer.removeElement(eventAnalyzer);
    }

    public void removeAllEventAnalyzers() {
        this.m_analyzer.removeAllElements();
    }

    private void resetFolders() {
        PeerSupport.resetFolders(this.m_hepJob);
    }

    private void goEnded() {
        PeerSupport.done(this.m_hepJob);
    }

    public void go(int n) {
        Object object;
        if (n < 0) {
            throw new IllegalArgumentException("Argument to go < 0");
        }
        if (this.m_source == null) {
            throw new NoEventSourceSet();
        }
        if (this.m_atStart) {
            this.beforeFirstEvent();
            this.m_atStart = false;
        }
        Date date = new Date();
        System.out.println("Start go at: " + date);
        int n2 = 0;
        try {
            try {
                while (n == 0 || n2 < n) {
                    object = this.m_source.getNextEvent();
                    this.processEvent((EventData)object);
                    ++n2;
                }
            }
            catch (EndOfDataException endOfDataException) {
                this.afterLastEvent();
                Object var6_7 = null;
                this.goEnded();
            }
            Object var6_6 = null;
            this.goEnded();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.goEnded();
            throw throwable;
        }
        object = new Date();
        System.out.println("End go at: " + object);
        System.out.println("Analyzed " + n2 + " events in " + (((Date)object).getTime() - date.getTime()) + " milliSeconds");
    }

    public void rewind() {
        this.m_atStart = true;
    }

    private void beforeFirstEvent() {
        this.m_source.beforeFirstEvent();
        Enumeration enumeration = this.m_analyzer.elements();
        while (enumeration.hasMoreElements()) {
            EventAnalyzer eventAnalyzer = (EventAnalyzer)enumeration.nextElement();
            this.resetFolders();
            eventAnalyzer.beforeFirstEvent();
        }
    }

    private void afterLastEvent() {
        this.m_source.afterLastEvent();
        Enumeration enumeration = this.m_analyzer.elements();
        while (enumeration.hasMoreElements()) {
            EventAnalyzer eventAnalyzer = (EventAnalyzer)enumeration.nextElement();
            this.resetFolders();
            eventAnalyzer.afterLastEvent();
        }
    }

    private void processEvent(EventData eventData) {
        Enumeration enumeration = this.m_analyzer.elements();
        while (enumeration.hasMoreElements()) {
            EventAnalyzer eventAnalyzer = (EventAnalyzer)enumeration.nextElement();
            this.resetFolders();
            eventAnalyzer.processEvent(eventData);
        }
    }

    public void addNotify(NamedObject namedObject) {
    }

    public void removeNotify(NamedObject namedObject) {
    }

    public void changeNotify(NamedObject namedObject, String string) {
    }
}

