/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.AbstractTwoDFillable;
import hep.analysis.partition.RangeChangeListener;
import hep.analysis.partition.Statistics;
import hep.analysis.partition.StatisticsProvider;

public class TwoDStatisticsProvider
extends AbstractTwoDFillable
implements StatisticsProvider {
    private double m_xLow;
    private double m_xHigh;
    private double m_xMean;
    private double m_xRms;
    private double m_yLow;
    private double m_yHigh;
    private double m_yMean;
    private double m_yRms;
    private double m_totalWeight;
    private int m_entries;
    private RangeChangeListener m_xRange;
    private RangeChangeListener m_yRange;
    static final long serialVersionUID = -4389000125022775776L;

    TwoDStatisticsProvider() {
        this.clear();
    }

    TwoDStatisticsProvider(RangeChangeListener rangeChangeListener, RangeChangeListener rangeChangeListener2) {
        this.clear();
        this.m_xRange = rangeChangeListener;
        this.m_yRange = rangeChangeListener2;
    }

    void setRangeChangeListener(RangeChangeListener rangeChangeListener, RangeChangeListener rangeChangeListener2) {
        this.m_xRange = rangeChangeListener;
        this.m_yRange = rangeChangeListener2;
    }

    public void fillW(double d, double d2, double d3) {
        boolean bl;
        this.m_totalWeight += d3;
        this.m_xMean += d * d3;
        this.m_xRms += d * d * d3;
        this.m_yMean += d2 * d3;
        this.m_yRms += d2 * d2 * d3;
        if (this.m_entries++ == 0) {
            this.m_xLow = this.m_xHigh = d;
            this.m_yLow = this.m_yHigh = d2;
            if (this.m_xRange != null) {
                this.m_xRange.rangeChanged(d, d);
            }
            if (this.m_yRange != null) {
                this.m_yRange.rangeChanged(d2, d2);
            }
            return;
        }
        boolean bl2 = d < this.m_xLow;
        boolean bl3 = bl = d > this.m_xHigh;
        if (bl2 || bl) {
            if (bl2) {
                this.m_xLow = d;
            }
            if (bl) {
                this.m_xHigh = d;
            }
            if (this.m_xRange != null) {
                this.m_xRange.rangeChanged(this.m_xLow, this.m_xHigh);
            }
        }
        bl2 = d2 < this.m_yLow;
        boolean bl4 = bl = d2 > this.m_yHigh;
        if (bl2 || bl) {
            if (bl2) {
                this.m_yLow = d2;
            }
            if (bl) {
                this.m_yHigh = d2;
            }
            if (this.m_yRange != null) {
                this.m_yRange.rangeChanged(this.m_yLow, this.m_yHigh);
            }
        }
    }

    public void clear() {
        this.m_entries = 0;
        this.m_totalWeight = 0.0;
        this.m_xMean = 0.0;
        this.m_xRms = 0.0;
        this.m_xLow = 0.0;
        this.m_xHigh = 0.0;
        this.m_yMean = 0.0;
        this.m_yRms = 0.0;
        this.m_yLow = 0.0;
        this.m_yHigh = 0.0;
    }

    public int getEntries() {
        return this.m_entries;
    }

    public double getXMean() {
        return this.m_xMean / this.m_totalWeight;
    }

    public double getXRMS() {
        return Math.sqrt(this.m_xRms / this.m_totalWeight - this.m_xMean * this.m_xMean / this.m_totalWeight / this.m_totalWeight);
    }

    public double getXMin() {
        return this.m_xLow;
    }

    public double getXMax() {
        return this.m_xHigh;
    }

    public double getYMean() {
        return this.m_yMean / this.m_totalWeight;
    }

    public double getYRMS() {
        return Math.sqrt(this.m_yRms / this.m_totalWeight - this.m_yMean * this.m_yMean / this.m_totalWeight / this.m_totalWeight);
    }

    public double getYMin() {
        return this.m_yLow;
    }

    public double getYMax() {
        return this.m_yHigh;
    }

    public Statistics getStatistics() {
        Statistics statistics = new Statistics(9);
        statistics.setStatistic("entries", this.getEntries());
        statistics.setStatistic("x mean", this.getXMean());
        statistics.setStatistic("x rms", this.getXRMS());
        statistics.setStatistic("x min", this.getXMin());
        statistics.setStatistic("x max", this.getXMax());
        statistics.setStatistic("y mean", this.getYMean());
        statistics.setStatistic("y rms", this.getYRMS());
        statistics.setStatistic("y min", this.getYMin());
        statistics.setStatistic("y max", this.getYMax());
        return statistics;
    }
}

