/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.NoSuchBinException;
import hep.analysis.partition.Abstract2DPartition;
import hep.analysis.partition.BinInfo;
import hep.analysis.partition.Statistics;
import hep.analysis.partition.StatisticsProvider;
import hep.analysis.partition.TwoDDataSource;
import hep.analysis.partition.TwoDFillable;
import java.util.Date;

public abstract class TwoDDelegatingPartition
extends Abstract2DPartition {
    private BinInfo infoX;
    private BinInfo infoY;
    private TwoDFillable fillable;
    private TwoDDataSource dataSource;
    private StatisticsProvider statisticsProvider;
    static final long serialVersionUID = 3773691152490375678L;

    public void fill(double d, double d2) {
        this.fillable.fill(d, d2);
        this.setDataChanged();
    }

    public void fillW(double d, double d2, double d3) {
        this.fillable.fillW(d, d2, d3);
        this.setDataChanged();
    }

    public void fill(Date date, double d) {
        this.fillable.fill(date, d);
        this.setDataChanged();
    }

    public void fillW(Date date, double d, double d2) {
        this.fillable.fillW(date, d, d2);
        this.setDataChanged();
    }

    public void clear() {
        this.fillable.clear();
        super.clear();
    }

    public Statistics getStatistics() {
        return this.statisticsProvider.getStatistics();
    }

    public boolean hasAsymmetricErrorBars() {
        return this.dataSource.hasAsymmetricErrorBars();
    }

    public boolean hasSimpleQuadraticErrorBars() {
        return this.dataSource.hasSimpleQuadraticErrorBars();
    }

    public double[][] getPlusErrors() {
        return this.dataSource.getPlusErrors();
    }

    public double[][] getMinusErrors() {
        return this.dataSource.getMinusErrors();
    }

    public double[][] getBins() {
        this.clearDataChanged();
        return this.dataSource.getBins();
    }

    public double getBin(int n, int n2) throws NoSuchBinException {
        return this.dataSource.getBins()[n][n2];
    }

    public boolean isRebinnable() {
        return this.dataSource.isRebinnable();
    }

    public void setXBinning(int n, double d, double d2) {
        this.dataSource.setXBinning(n, d, d2);
    }

    public void setYBinning(int n, double d, double d2) {
        this.dataSource.setYBinning(n, d, d2);
    }

    public String[] getXAxisLabels() {
        return this.dataSource.getXAxisLabels();
    }

    public String[] getYAxisLabels() {
        return this.dataSource.getYAxisLabels();
    }

    public int getXAxisType() {
        return this.dataSource.getXAxisType();
    }

    public int getYAxisType() {
        return this.dataSource.getYAxisType();
    }

    public int getNumberOfXBins() {
        return this.infoX.getNumberOfBins();
    }

    public int getNumberOfYBins() {
        return this.infoY.getNumberOfBins();
    }

    public double getXMin() {
        return this.infoX.getMin();
    }

    public double getYMin() {
        return this.infoY.getMin();
    }

    public double getXMax() {
        return this.infoX.getMax();
    }

    public double getYMax() {
        return this.infoY.getMax();
    }

    protected void setFillable(TwoDFillable twoDFillable) {
        this.fillable = twoDFillable;
    }

    protected void setDataSource(TwoDDataSource twoDDataSource) {
        this.dataSource = twoDDataSource;
    }

    protected void setStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void setBinInfoX(BinInfo binInfo) {
        this.infoX = binInfo;
    }

    protected void setBinInfoY(BinInfo binInfo) {
        this.infoY = binInfo;
    }
}

