/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.BinType;
import hep.analysis.partition.SimpleTwoDDataSource;
import hep.analysis.partition.TwoDBinner;
import java.io.Serializable;

public class TwoDBinTypeAdapter
implements TwoDBinner,
SimpleTwoDDataSource,
Serializable {
    private int xBins;
    private int yBins;
    private BinType type;
    static final long serialVersionUID = -3741465661266122772L;

    TwoDBinTypeAdapter(BinType binType, int n, int n2) {
        this.type = binType;
        this.xBins = n;
        this.yBins = n2;
        binType.clear();
        binType.setNumberOfBins(n * n2);
    }

    public void fill(int n, int n2) {
        this.type.fill(n2 * this.xBins + n);
    }

    public void fillW(int n, int n2, double d) {
        this.type.fillW(n2 * this.xBins + n, d);
    }

    public void clear() {
        this.type.clear();
    }

    public void setNumberOfBins(int n, int n2) {
        this.clear();
        this.xBins = n;
        this.yBins = n2;
        this.type.setNumberOfBins(n * n2);
    }

    public int getNumberOfXBins() {
        return this.xBins;
    }

    public int getNumberOfYBins() {
        return this.yBins;
    }

    public boolean hasSimpleQuadraticErrorBars() {
        return this.type.hasSimpleQuadraticErrorBars();
    }

    public boolean hasAsymmetricErrorBars() {
        return this.type.hasAsymmetricErrorBars();
    }

    public double[][] getBins() {
        int n = 0;
        double[] dArray = this.type.getBins();
        double[][] dArray2 = new double[this.xBins][this.yBins];
        int n2 = 0;
        while (n2 < this.yBins) {
            int n3 = 0;
            while (n3 < this.xBins) {
                dArray2[n3][n2] = dArray[n++];
                ++n3;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] getPlusErrors() {
        int n = 0;
        double[] dArray = this.type.getPlusErrors();
        double[][] dArray2 = new double[this.xBins][this.yBins];
        int n2 = 0;
        while (n2 < this.yBins) {
            int n3 = 0;
            while (n3 < this.xBins) {
                dArray2[n3][n2] = dArray[n++];
                ++n3;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] getMinusErrors() {
        int n = 0;
        double[] dArray = this.type.getMinusErrors();
        double[][] dArray2 = new double[this.xBins][this.yBins];
        int n2 = 0;
        while (n2 < this.yBins) {
            int n3 = 0;
            while (n3 < this.xBins) {
                dArray2[n3][n2] = dArray[n++];
                ++n3;
            }
            ++n2;
        }
        return dArray2;
    }
}

