/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.AbstractBinFinder;
import hep.analysis.partition.BinInfo;
import hep.analysis.partition.RangeChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class StringBinFinder
extends AbstractBinFinder
implements BinInfo,
Serializable {
    private RangeChangeListener m_range;
    private int nbins = 0;
    private Hashtable h = new Hashtable();
    static final long serialVersionUID = 3678178302197833674L;

    public StringBinFinder(RangeChangeListener rangeChangeListener) {
        this.m_range = rangeChangeListener;
    }

    public int getBinAt(String string) {
        Integer n = (Integer)this.h.get(string);
        if (n == null) {
            n = new Integer(this.nbins++);
            this.h.put(string, n);
            this.m_range.rangeChanged(0.0, this.nbins);
        }
        return n;
    }

    public void clear() {
        this.h.clear();
        this.nbins = 0;
    }

    public int getNumberOfBins() {
        return this.nbins;
    }

    public String[] getBinNames() {
        String[] stringArray = new String[this.nbins];
        Enumeration enumeration = this.h.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)this.h.get(string);
            stringArray[n.intValue()] = string;
        }
        return stringArray;
    }

    public double getMin() {
        return 0.0;
    }

    public double getMax() {
        return this.nbins;
    }
}

