/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;

public class Statistics
implements Serializable {
    private final Vector m_stats;
    private final Vector m_values;
    static final long serialVersionUID = -9061569144762379833L;

    public Statistics(int n) {
        this.m_stats = new Vector(n);
        this.m_values = new Vector(n);
    }

    public final void setStatistic(String string, double d) {
        this.setStatistic(string, new Double(d));
    }

    public final void setStatistic(String string, Object object) {
        this.m_stats.addElement(string);
        this.m_values.addElement(object);
    }

    public final Enumeration elements() {
        return this.m_stats.elements();
    }

    public final String[] getStatisticNames() {
        Object[] objectArray = new String[this.m_stats.size()];
        this.m_stats.copyInto(objectArray);
        return objectArray;
    }

    public final Object getStatisticObject(String string) {
        int n = this.m_stats.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("Statistic " + string + " not found.");
        }
        return this.m_values.elementAt(n);
    }

    public final double getStatistic(String string) {
        int n = this.m_stats.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("Statistic " + string + " not found.");
        }
        return (Double)this.m_values.elementAt(n);
    }

    public final double getStatistic(String string, double d) {
        int n = this.m_stats.indexOf(string);
        if (n < 0) {
            return d;
        }
        return (Double)this.m_values.elementAt(n);
    }

    public final void clear() {
        this.m_stats.removeAllElements();
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.m_stats.size()) {
            String string = (String)this.m_stats.elementAt(n);
            Object e = this.m_values.elementAt(n);
            if (e instanceof Double) {
                double d = (Double)this.m_values.elementAt(n);
                stringBuffer.append(string + "=" + numberFormat.format(d));
            } else {
                stringBuffer.append(string + "=" + e.toString());
            }
            if (++n == this.m_stats.size()) break;
            stringBuffer.append(" , ");
        }
        return stringBuffer.toString();
    }
}

