/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.AbstractTwoDFillable;
import hep.analysis.partition.PartitionEnumeration;
import hep.analysis.partition.PartitionVector;
import hep.analysis.partition.TwoDFillable;
import hep.analysis.partition.TwoDStorer;

public class SimpleTwoDStorer
extends AbstractTwoDFillable
implements TwoDStorer {
    private PartitionVector m_simple = new PartitionVector(2);
    private PartitionVector m_weighted = new PartitionVector(3);
    private double[] m_currentSimple;
    private double[] m_currentWeighted;
    private int m_countSimple;
    private int m_countWeighted;
    private int m_simpleEntriesFilled;
    private int m_weightedEntriesFilled;
    static final long serialVersionUID = -6804277295912816740L;

    public SimpleTwoDStorer() {
        this.clear();
    }

    public void fill(double d, double d2) {
        try {
            this.m_currentSimple[this.m_countSimple++] = d;
            this.m_currentSimple[this.m_countSimple++] = d2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.m_currentSimple = this.m_simple.newArray();
            this.m_countSimple = 0;
            this.m_currentSimple[this.m_countSimple++] = d;
            this.m_currentSimple[this.m_countSimple++] = d2;
        }
        ++this.m_simpleEntriesFilled;
    }

    public void fillW(double d, double d2, double d3) {
        try {
            this.m_currentWeighted[this.m_countWeighted++] = d;
            this.m_currentWeighted[this.m_countWeighted++] = d2;
            this.m_currentWeighted[this.m_countWeighted++] = d3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.m_currentWeighted = this.m_weighted.newArray();
            this.m_countWeighted = 0;
            this.m_currentWeighted[this.m_countWeighted++] = d;
            this.m_currentWeighted[this.m_countWeighted++] = d2;
            this.m_currentWeighted[this.m_countWeighted++] = d3;
        }
        ++this.m_weightedEntriesFilled;
    }

    public void fillData(TwoDFillable twoDFillable) {
        PartitionEnumeration partitionEnumeration = this.m_simple.elements();
        partitionEnumeration.setEndPoint(this.m_simpleEntriesFilled);
        while (partitionEnumeration.hasMoreElements()) {
            twoDFillable.fill(partitionEnumeration.nextValue(), partitionEnumeration.nextValue());
        }
        partitionEnumeration = this.m_weighted.elements();
        partitionEnumeration.setEndPoint(this.m_weightedEntriesFilled);
        while (partitionEnumeration.hasMoreElements()) {
            twoDFillable.fillW(partitionEnumeration.nextValue(), partitionEnumeration.nextValue(), partitionEnumeration.nextValue());
        }
    }

    public void clear() {
        this.m_simple.clear();
        this.m_weighted.clear();
        this.m_currentSimple = this.m_simple.newArray();
        this.m_currentWeighted = this.m_weighted.newArray();
        this.m_countSimple = 0;
        this.m_countWeighted = 0;
        this.m_simpleEntriesFilled = 0;
        this.m_weightedEntriesFilled = 0;
    }
}

