/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.AbstractOneDFillable;
import hep.analysis.partition.OneDFillable;
import hep.analysis.partition.PartitionEnumeration;
import hep.analysis.partition.PartitionVector;

public class SimpleStorer
extends AbstractOneDFillable {
    private PartitionVector m_simple = new PartitionVector(1);
    private PartitionVector m_weighted = new PartitionVector(2);
    private double[] m_currentSimple;
    private double[] m_currentWeighted;
    private int m_countSimple;
    private int m_countWeighted;
    private int m_simpleEntriesFilled;
    private int m_weightedEntriesFilled;
    static final long serialVersionUID = 50202889440605209L;

    public SimpleStorer() {
        this.clear();
    }

    public void fill(double d) {
        try {
            this.m_currentSimple[this.m_countSimple++] = d;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.m_currentSimple = this.m_simple.newArray();
            this.m_countSimple = 0;
            this.m_currentSimple[this.m_countSimple++] = d;
        }
        ++this.m_simpleEntriesFilled;
    }

    public void fillW(double d, double d2) {
        try {
            this.m_currentWeighted[this.m_countWeighted++] = d;
            this.m_currentWeighted[this.m_countWeighted++] = d2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.m_currentWeighted = this.m_weighted.newArray();
            this.m_countWeighted = 0;
            this.m_currentWeighted[this.m_countWeighted++] = d;
            this.m_currentWeighted[this.m_countWeighted++] = d2;
        }
        ++this.m_weightedEntriesFilled;
    }

    public void fillData(OneDFillable oneDFillable) {
        PartitionEnumeration partitionEnumeration = this.m_simple.elements();
        partitionEnumeration.setEndPoint(this.m_simpleEntriesFilled);
        while (partitionEnumeration.hasMoreElements()) {
            oneDFillable.fill(partitionEnumeration.nextValue());
        }
        partitionEnumeration = this.m_weighted.elements();
        partitionEnumeration.setEndPoint(this.m_weightedEntriesFilled);
        while (partitionEnumeration.hasMoreElements()) {
            oneDFillable.fillW(partitionEnumeration.nextValue(), partitionEnumeration.nextValue());
        }
    }

    public void clear() {
        this.m_simple.clear();
        this.m_weighted.clear();
        this.m_currentSimple = this.m_simple.newArray();
        this.m_currentWeighted = this.m_weighted.newArray();
        this.m_countSimple = 0;
        this.m_countWeighted = 0;
        this.m_simpleEntriesFilled = 0;
        this.m_weightedEntriesFilled = 0;
    }
}

