/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.AbstractTwoDFillable;
import hep.analysis.partition.PartitionEnumeration;
import hep.analysis.partition.PartitionFillException;
import hep.analysis.partition.PartitionVector;
import hep.analysis.partition.ScatterEnumeration;
import hep.analysis.partition.TwoDFillable;
import hep.analysis.partition.TwoDStorer;

public class SimpleScatterStorer
extends AbstractTwoDFillable
implements TwoDStorer {
    private PartitionVector m_simple = new PartitionVector(2);
    private double[] m_currentSimple;
    private int m_countSimple;
    private int m_simpleEntriesFilled;
    static final long serialVersionUID = 7972941040483599277L;

    public SimpleScatterStorer() {
        this.clear();
    }

    public void fill(double d, double d2) {
        try {
            this.m_currentSimple[this.m_countSimple++] = d;
            this.m_currentSimple[this.m_countSimple++] = d2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.m_currentSimple = this.m_simple.newArray();
            this.m_countSimple = 0;
            this.m_currentSimple[this.m_countSimple++] = d;
            this.m_currentSimple[this.m_countSimple++] = d2;
        }
        ++this.m_simpleEntriesFilled;
    }

    public void fillW(double d, double d2, double d3) {
        throw new PartitionFillException();
    }

    public void fillData(TwoDFillable twoDFillable) {
        PartitionEnumeration partitionEnumeration = this.m_simple.elements();
        partitionEnumeration.setEndPoint(this.m_simpleEntriesFilled);
        while (partitionEnumeration.hasMoreElements()) {
            twoDFillable.fill(partitionEnumeration.nextValue(), partitionEnumeration.nextValue());
        }
    }

    public ScatterEnumeration startEnumeration() {
        final PartitionEnumeration partitionEnumeration = this.m_simple.elements();
        partitionEnumeration.setEndPoint(this.m_simpleEntriesFilled);
        return new ScatterEnumeration(){

            public final boolean getNextPoint(double[] dArray) {
                if (!partitionEnumeration.hasMoreElements()) {
                    return false;
                }
                dArray[0] = partitionEnumeration.nextValue();
                dArray[1] = partitionEnumeration.nextValue();
                return true;
            }

            public final void resetEndPoint() {
                partitionEnumeration.setEndPoint(SimpleScatterStorer.this.m_simpleEntriesFilled);
            }

            public final void restart() {
                partitionEnumeration.restart();
            }
        };
    }

    public ScatterEnumeration startEnumeration(final double d, final double d2, final double d3, final double d4) {
        final PartitionEnumeration partitionEnumeration = this.m_simple.elements();
        partitionEnumeration.setEndPoint(this.m_simpleEntriesFilled);
        return new ScatterEnumeration(){

            public final boolean getNextPoint(double[] dArray) {
                double d5;
                double d22;
                do {
                    if (!partitionEnumeration.hasMoreElements()) {
                        return false;
                    }
                    d22 = partitionEnumeration.nextValue();
                    d5 = partitionEnumeration.nextValue();
                } while (d22 < d || d22 > d2 || d5 < d3 || d5 > d4);
                dArray[0] = d22;
                dArray[1] = d5;
                return true;
            }

            public final void resetEndPoint() {
                partitionEnumeration.setEndPoint(SimpleScatterStorer.this.m_simpleEntriesFilled);
            }

            public final void restart() {
                partitionEnumeration.restart();
            }
        };
    }

    public void clear() {
        this.m_simple.clear();
        this.m_currentSimple = this.m_simple.newArray();
        this.m_countSimple = 0;
        this.m_simpleEntriesFilled = 0;
    }
}

