/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.Partition;
import hep.analysis.partition.BinAdapter;
import hep.analysis.partition.BinType;
import hep.analysis.partition.FillableTee;
import hep.analysis.partition.OneDDelegatingPartition;
import hep.analysis.partition.OneDStatisticsProvider;
import hep.analysis.partition.SimpleBinFinder;
import hep.analysis.partition.SimpleBinner;
import hep.analysis.partition.SimpleBinnerDataSourceAdapter;
import hep.analysis.partition.SimpleStorer;
import hep.analysis.partition.Statistics;

public class SimplePartition
extends OneDDelegatingPartition {
    protected double m_min;
    protected double m_max;
    protected boolean m_autoRange;
    protected int m_defaultBins;
    private BinType m_type;
    private SimpleStorer m_storer;
    private OneDStatisticsProvider m_stats;
    static final long serialVersionUID = 1464862023276245054L;

    public SimplePartition() {
        this(40);
    }

    public SimplePartition(int n) {
        this(new SimpleBinner(n));
    }

    public SimplePartition(BinType binType) {
        this.m_type = binType;
        this.m_autoRange = true;
        this.m_defaultBins = binType.getNumberOfBins();
        this.m_storer = new SimpleStorer();
        this.m_stats = new OneDStatisticsProvider(this);
        this.setFillable(new FillableTee(this.m_storer, this.m_stats));
        this.setStatisticsProvider(this.m_stats);
    }

    public SimplePartition(double d, double d2) {
        this(d, d2, 40);
    }

    public SimplePartition(double d, double d2, int n) {
        this(d, d2, new SimpleBinner(n));
    }

    public SimplePartition(double d, double d2, BinType binType) {
        if (d2 <= d) {
            throw new IllegalArgumentException("max <= min");
        }
        this.m_type = binType;
        this.m_autoRange = false;
        this.m_min = d;
        this.m_max = d2;
        this.m_defaultBins = binType.getNumberOfBins();
        this.m_storer = new SimpleStorer();
        this.setFillable(this.m_storer);
    }

    public void setBinning(int n, double d, double d2) {
        SimpleBinFinder simpleBinFinder = new SimpleBinFinder(n, d, d2, false);
        this.m_type.setNumberOfBins(n);
        this.m_type.clear();
        BinAdapter binAdapter = new BinAdapter(simpleBinFinder, this.m_type);
        this.m_storer.fillData(binAdapter);
        this.setDataSource(new SimpleBinnerDataSourceAdapter(simpleBinFinder, this.m_type));
    }

    public int getNumberOfBins() {
        return this.m_defaultBins;
    }

    public double getMin() {
        this.clearRangeChanged();
        if (this.m_autoRange) {
            return this.m_stats.getMin();
        }
        return this.m_min;
    }

    public double getMax() {
        this.clearRangeChanged();
        if (this.m_autoRange) {
            return this.m_stats.getMax();
        }
        return this.m_max;
    }

    public Statistics getStatistics() {
        if (this.m_autoRange) {
            return this.m_stats.getStatistics();
        }
        OneDStatisticsProvider oneDStatisticsProvider = new OneDStatisticsProvider();
        this.m_storer.fillData(oneDStatisticsProvider);
        return oneDStatisticsProvider.getStatistics();
    }

    public boolean isRebinnable() {
        return true;
    }

    public int getAxisType() {
        return 1;
    }

    public Partition makeCopy() {
        if (this.m_autoRange) {
            return new SimplePartition(this.m_defaultBins);
        }
        return new SimplePartition(this.m_min, this.m_max, this.m_defaultBins);
    }
}

