/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.BinType;

public class SimpleBinner
implements BinType {
    protected int m_bins;
    protected double[] m_hist;
    protected double[] m_error;
    private boolean m_hasWeightedEntries;
    static final long serialVersionUID = 8695712331891724491L;

    public SimpleBinner(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("bins <= 0");
        }
        this.m_bins = n;
        this.clear();
    }

    public void clear() {
        this.m_hist = new double[this.m_bins];
        this.m_error = new double[this.m_bins];
        this.m_hasWeightedEntries = false;
    }

    public void fill(int n) {
        int n2 = n;
        this.m_hist[n2] = this.m_hist[n2] + 1.0;
        int n3 = n;
        this.m_error[n3] = this.m_error[n3] + 1.0;
    }

    public void fillW(int n, double d) {
        int n2 = n;
        this.m_hist[n2] = this.m_hist[n2] + d;
        int n3 = n;
        this.m_error[n3] = this.m_error[n3] + d * d;
        this.m_hasWeightedEntries = true;
    }

    public double[] getBins() {
        return this.m_hist;
    }

    public double[] getPlusErrors() {
        double[] dArray = new double[this.m_bins];
        int n = 0;
        while (n < this.m_bins) {
            dArray[n] = Math.sqrt(this.m_error[n]);
            ++n;
        }
        return dArray;
    }

    public double[] getMinusErrors() {
        return this.getPlusErrors();
    }

    public void setNumberOfBins(int n) {
        if (n == this.m_bins) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        System.arraycopy(this.m_hist, 0, dArray, 0, Math.min(n, this.m_bins));
        System.arraycopy(this.m_error, 0, dArray2, 0, Math.min(n, this.m_bins));
        this.m_hist = dArray;
        this.m_error = dArray2;
        this.m_bins = n;
    }

    public int getNumberOfBins() {
        return this.m_bins;
    }

    public boolean hasSimpleQuadraticErrorBars() {
        return !this.m_hasWeightedEntries;
    }

    public boolean hasAsymmetricErrorBars() {
        return false;
    }
}

