/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.AbstractBinFinder;
import hep.analysis.partition.BinInfo;

public class SimpleBinFinder
extends AbstractBinFinder
implements BinInfo {
    private double min;
    private double max;
    private double binWidth;
    private int bins;
    private int underflow;
    private int overflow;
    public static final int UNDERFLOW = -1;
    public static final int OVERFLOW = -2;
    static final long serialVersionUID = 3140155930261652478L;

    SimpleBinFinder(int n, double d, double d2, boolean bl) {
        this.bins = n;
        this.min = d;
        this.max = d2;
        this.binWidth = (d2 - d) / (double)n;
        if (bl) {
            this.underflow = n;
            this.overflow = n + 1;
        } else {
            this.overflow = -2;
            this.underflow = -1;
        }
    }

    public int getBinAt(double d) {
        int n = (int)Math.floor((d - this.min) / this.binWidth);
        if (n < 0) {
            n = this.underflow;
        } else if (n >= this.bins) {
            n = this.overflow;
        }
        return n;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getNumberOfBins() {
        return this.bins;
    }
}

