/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.Partition;
import hep.analysis.partition.Abstract2DPartition;
import hep.analysis.partition.BinType;
import hep.analysis.partition.RangeChangeListener;
import hep.analysis.partition.SimpleBinFinder;
import hep.analysis.partition.SimpleBinner;
import hep.analysis.partition.SimpleTwoDDataSourceAdapter;
import hep.analysis.partition.SimpleTwoDStorer;
import hep.analysis.partition.Statistics;
import hep.analysis.partition.TwoDBinAdapter;
import hep.analysis.partition.TwoDBinTypeAdapter;
import hep.analysis.partition.TwoDDataSource;
import hep.analysis.partition.TwoDFillable;
import hep.analysis.partition.TwoDFillableTee;
import hep.analysis.partition.TwoDStatisticsProvider;
import hep.analysis.partition.TwoDStorer;

public class Simple2DPartition
extends Abstract2DPartition {
    private TwoDStorer m_storer;
    private TwoDStatisticsProvider m_stats;
    private TwoDFillable m_filler;
    private double m_xMin;
    private double m_xMax;
    private double m_yMin;
    private double m_yMax;
    private boolean m_rangeSet;
    private BinType m_type = new SimpleBinner(0);
    private int m_xBins;
    private double m_xBinLow;
    private double m_xBinHigh;
    private int m_yBins;
    private double m_yBinLow;
    private double m_yBinHigh;
    private TwoDDataSource m_source;
    static final long serialVersionUID = -1795657090122338079L;

    public Simple2DPartition() {
        this.m_rangeSet = false;
        this.m_storer = this.createStorer();
        RangeChangeListener rangeChangeListener = this.getRangeChangeListener(0);
        RangeChangeListener rangeChangeListener2 = this.getRangeChangeListener(1);
        this.m_stats = new TwoDStatisticsProvider(rangeChangeListener, rangeChangeListener2);
        this.m_filler = new TwoDFillableTee(this.m_storer, this.m_stats);
    }

    public Simple2DPartition(double d, double d2, double d3, double d4) {
        this.m_rangeSet = true;
        this.m_xMin = d;
        this.m_xMax = d2;
        this.m_yMin = d3;
        this.m_yMax = d4;
        this.m_storer = this.createStorer();
    }

    protected TwoDStorer createStorer() {
        return new SimpleTwoDStorer();
    }

    public void fill(double d, double d2) {
        this.m_filler.fill(d, d2);
        this.setDataChanged();
    }

    public void fillW(double d, double d2, double d3) {
        this.m_filler.fillW(d, d2, d3);
        this.setDataChanged();
    }

    public void clear() {
        this.m_filler.clear();
        this.m_source = null;
        super.clear();
    }

    public double getXMin() {
        if (this.m_rangeSet) {
            return this.m_xMin;
        }
        return this.m_stats.getXMin();
    }

    public double getXMax() {
        if (this.m_rangeSet) {
            return this.m_xMax;
        }
        return this.m_stats.getXMax();
    }

    public double getYMin() {
        if (this.m_rangeSet) {
            return this.m_yMin;
        }
        return this.m_stats.getYMin();
    }

    public double getYMax() {
        if (this.m_rangeSet) {
            return this.m_yMax;
        }
        return this.m_stats.getYMax();
    }

    public void setXBinning(int n, double d, double d2) {
        if (n != this.m_xBins || d != this.m_xBinLow || d2 != this.m_xBinHigh) {
            this.m_xBins = n;
            this.m_xBinLow = d;
            this.m_xBinHigh = d2;
        }
        this.m_source = null;
    }

    public void setYBinning(int n, double d, double d2) {
        if (n != this.m_yBins || d != this.m_yBinLow || d2 != this.m_yBinHigh) {
            this.m_yBins = n;
            this.m_yBinLow = d;
            this.m_yBinHigh = d2;
        }
        this.m_source = null;
    }

    private void doBin() {
        this.clearDataChanged();
        SimpleBinFinder simpleBinFinder = new SimpleBinFinder(this.m_xBins, this.m_xBinLow, this.m_xBinHigh, false);
        SimpleBinFinder simpleBinFinder2 = new SimpleBinFinder(this.m_yBins, this.m_yBinLow, this.m_yBinHigh, false);
        TwoDBinTypeAdapter twoDBinTypeAdapter = new TwoDBinTypeAdapter(this.m_type, this.m_xBins, this.m_yBins);
        TwoDBinAdapter twoDBinAdapter = new TwoDBinAdapter(simpleBinFinder, simpleBinFinder2, twoDBinTypeAdapter);
        this.m_storer.fillData(twoDBinAdapter);
        this.m_source = new SimpleTwoDDataSourceAdapter(simpleBinFinder, simpleBinFinder2, twoDBinTypeAdapter);
    }

    public double[][] getBins() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getBins();
    }

    public double[][] getPlusErrors() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getPlusErrors();
    }

    public double[][] getMinusErrors() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getMinusErrors();
    }

    public Statistics getStatistics() {
        return this.m_stats.getStatistics();
    }

    public int getNumberOfXBins() {
        return 40;
    }

    public int getNumberOfYBins() {
        return 40;
    }

    public boolean isRebinnable() {
        return true;
    }

    public boolean hasAsymmetricErrorBars() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.hasAsymmetricErrorBars();
    }

    public boolean hasSimpleQuadraticErrorBars() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.hasSimpleQuadraticErrorBars();
    }

    public String[] getXAxisLabels() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getXAxisLabels();
    }

    public String[] getYAxisLabels() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getYAxisLabels();
    }

    public Partition makeCopy() {
        if (this.m_rangeSet) {
            return new Simple2DPartition(this.m_xMin, this.m_xMax, this.m_yMin, this.m_yMax);
        }
        return new Simple2DPartition();
    }
}

