/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.BinType;
import hep.analysis.partition.PartitionFillException;

public class RMSBinner
implements BinType {
    protected int m_bins;
    protected double[] m_hist;
    protected double[] m_error;
    protected double[] m_n;
    static final long serialVersionUID = -5351379217539362772L;

    public RMSBinner(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("bins <= 0");
        }
        this.m_bins = n;
        this.clear();
    }

    public void clear() {
        this.m_n = new double[this.m_bins];
        this.m_hist = new double[this.m_bins];
        this.m_error = new double[this.m_bins];
    }

    public void fill(int n) {
        throw new PartitionFillException();
    }

    public void fillW(int n, double d) {
        int n2 = n;
        this.m_n[n2] = this.m_n[n2] + 1.0;
        int n3 = n;
        this.m_hist[n3] = this.m_hist[n3] + d;
        int n4 = n;
        this.m_error[n4] = this.m_error[n4] + d * d;
    }

    public double[] getBins() {
        double[] dArray = new double[this.m_bins];
        int n = 0;
        while (n < this.m_bins) {
            dArray[n] = this.m_hist[n] / this.m_n[n];
            ++n;
        }
        return dArray;
    }

    public double[] getPlusErrors() {
        double[] dArray = new double[this.m_bins];
        int n = 0;
        while (n < this.m_bins) {
            dArray[n] = Math.sqrt(this.m_error[n] / this.m_n[n] - this.m_hist[n] * this.m_hist[n] / this.m_n[n] / this.m_n[n]);
            ++n;
        }
        return dArray;
    }

    public double[] getMinusErrors() {
        return this.getPlusErrors();
    }

    public void setNumberOfBins(int n) {
        if (n == this.m_bins) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        System.arraycopy(this.m_hist, 0, dArray, 0, Math.min(n, this.m_bins));
        System.arraycopy(this.m_error, 0, dArray2, 0, Math.min(n, this.m_bins));
        System.arraycopy(this.m_n, 0, dArray3, 0, Math.min(n, this.m_bins));
        this.m_hist = dArray;
        this.m_error = dArray2;
        this.m_n = dArray3;
        this.m_bins = n;
    }

    public int getNumberOfBins() {
        return this.m_bins;
    }

    public boolean hasSimpleQuadraticErrorBars() {
        return false;
    }

    public boolean hasAsymmetricErrorBars() {
        return false;
    }
}

