/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.AbstractOneDFillable;
import hep.analysis.partition.RangeChangeListener;
import hep.analysis.partition.Statistics;
import hep.analysis.partition.StatisticsProvider;

public class OneDStatisticsProvider
extends AbstractOneDFillable
implements StatisticsProvider {
    private double m_low;
    private double m_high;
    private double m_binWidth;
    private double m_totalWeight;
    private double m_mean;
    private double m_rms;
    private int m_entries;
    private RangeChangeListener m_range;
    static final long serialVersionUID = -5062359468376470137L;

    OneDStatisticsProvider(double d) {
        this.clear();
        this.m_binWidth = d;
    }

    OneDStatisticsProvider() {
        this.clear();
    }

    OneDStatisticsProvider(RangeChangeListener rangeChangeListener) {
        this.clear();
        this.m_range = rangeChangeListener;
    }

    void setRangeChangeListener(RangeChangeListener rangeChangeListener) {
        this.m_range = rangeChangeListener;
    }

    public void fillW(double d, double d2) {
        boolean bl;
        this.m_totalWeight += d2;
        this.m_mean += d * d2;
        this.m_rms += d * d * d2;
        if (this.m_entries++ == 0) {
            this.m_low = this.m_high = d;
            if (this.m_range != null) {
                this.m_range.rangeChanged(d, d);
            }
            return;
        }
        boolean bl2 = d < this.m_low;
        boolean bl3 = bl = d > this.m_high;
        if (bl2 || bl) {
            if (bl2) {
                this.m_low = d;
            }
            if (bl) {
                this.m_high = d;
            }
            if (this.m_range != null) {
                this.m_range.rangeChanged(this.m_low, this.m_high);
            }
        }
    }

    public void clear() {
        this.m_entries = 0;
        this.m_totalWeight = 0.0;
        this.m_binWidth = 0.0;
        this.m_mean = 0.0;
        this.m_rms = 0.0;
        this.m_low = 0.0;
        this.m_high = 0.0;
    }

    public int getEntries() {
        return this.m_entries;
    }

    public double getArea() {
        return this.m_totalWeight * this.m_binWidth;
    }

    public double getMean() {
        return this.m_mean / this.m_totalWeight;
    }

    public double getRMS() {
        return Math.sqrt(this.m_rms / this.m_totalWeight - this.m_mean * this.m_mean / this.m_totalWeight / this.m_totalWeight);
    }

    public double getMin() {
        return this.m_low;
    }

    public double getMax() {
        return this.m_high;
    }

    public Statistics getStatistics() {
        Statistics statistics = new Statistics(6);
        statistics.setStatistic("entries", this.getEntries());
        if (this.m_binWidth > 0.0) {
            statistics.setStatistic("area", this.getArea());
        }
        statistics.setStatistic("mean", this.getMean());
        statistics.setStatistic("rms", this.getRMS());
        statistics.setStatistic("min", this.getMin());
        statistics.setStatistic("max", this.getMax());
        return statistics;
    }
}

