/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.partition.Abstract1DPartition;
import hep.analysis.partition.BinInfo;
import hep.analysis.partition.OneDDataSource;
import hep.analysis.partition.OneDFillable;
import hep.analysis.partition.Statistics;
import hep.analysis.partition.StatisticsProvider;
import java.util.Date;

public abstract class OneDDelegatingPartition
extends Abstract1DPartition {
    private BinInfo info;
    private OneDFillable fillable;
    private OneDDataSource dataSource;
    private StatisticsProvider statisticsProvider;
    static final long serialVersionUID = 1554079968617516284L;

    public void fill(double d) {
        this.fillable.fill(d);
        this.setDataChanged();
    }

    public void fill(int n) {
        this.fillable.fill(n);
        this.setDataChanged();
    }

    public void fill(String string) {
        this.fillable.fill(string);
        this.setDataChanged();
    }

    public void fill(Date date) {
        this.fillable.fill(date);
        this.setDataChanged();
    }

    public void fillW(double d, double d2) {
        this.fillable.fillW(d, d2);
        this.setDataChanged();
    }

    public void fillW(int n, double d) {
        this.fillable.fillW(n, d);
        this.setDataChanged();
    }

    public void fillW(String string, double d) {
        this.fillable.fillW(string, d);
        this.setDataChanged();
    }

    public void fillW(Date date, double d) {
        this.fillable.fillW(date, d);
        this.setDataChanged();
    }

    public void clear() {
        this.fillable.clear();
        super.clear();
    }

    public Statistics getStatistics() {
        return this.statisticsProvider.getStatistics();
    }

    public boolean hasAsymmetricErrorBars() {
        return this.dataSource.hasAsymmetricErrorBars();
    }

    public boolean hasSimpleQuadraticErrorBars() {
        return this.dataSource.hasSimpleQuadraticErrorBars();
    }

    public double[] getPlusErrors() {
        return this.dataSource.getPlusErrors();
    }

    public double[] getMinusErrors() {
        return this.dataSource.getMinusErrors();
    }

    public double[] getBins() {
        this.clearDataChanged();
        return this.dataSource.getBins();
    }

    public boolean isRebinnable() {
        return this.dataSource.isRebinnable();
    }

    public void setBinning(int n, double d, double d2) {
        this.dataSource.setBinning(n, d, d2);
    }

    public String[] getAxisLabels() {
        return this.dataSource.getAxisLabels();
    }

    public int getAxisType() {
        return this.dataSource.getAxisType();
    }

    public int getNumberOfBins() {
        return this.info.getNumberOfBins();
    }

    public double getMin() {
        this.clearRangeChanged();
        return this.info.getMin();
    }

    public double getMax() {
        this.clearRangeChanged();
        return this.info.getMax();
    }

    protected void setFillable(OneDFillable oneDFillable) {
        this.fillable = oneDFillable;
    }

    protected void setDataSource(OneDDataSource oneDDataSource) {
        this.dataSource = oneDDataSource;
    }

    protected void setStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void setBinInfo(BinInfo binInfo) {
        this.info = binInfo;
    }
}

