/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.Partition;
import hep.analysis.partition.BinAdapter;
import hep.analysis.partition.BinType;
import hep.analysis.partition.FillableTee;
import hep.analysis.partition.OneDDelegatingPartition;
import hep.analysis.partition.OneDStatisticsProvider;
import hep.analysis.partition.SimpleBinFinder;
import hep.analysis.partition.SimpleBinner;
import hep.analysis.partition.SimpleBinnerDataSourceAdapter;
import hep.analysis.partition.SimpleStorer;
import hep.analysis.partition.Statistics;
import hep.analysis.partition.ThresholdListener;
import hep.analysis.partition.ThresholdStorer;

public class AutoPartition
extends OneDDelegatingPartition
implements ThresholdListener {
    protected double m_min;
    protected double m_max;
    protected boolean m_autoRange;
    protected boolean m_thresholdReached;
    protected int m_defaultBins;
    protected int m_autoCutoff;
    private BinType m_type;
    private SimpleStorer m_storer;
    private OneDStatisticsProvider m_stats;
    static final long serialVersionUID = -4479135908960997917L;

    public AutoPartition() {
        this(2000, 40);
    }

    public AutoPartition(int n, int n2) {
        this(n, new SimpleBinner(n2));
    }

    public AutoPartition(int n, BinType binType) {
        if (n <= 0) {
            throw new IllegalArgumentException("autoCutoff <= 0");
        }
        this.m_autoCutoff = n;
        this.m_type = binType;
        this.m_thresholdReached = false;
        this.m_autoRange = true;
        this.m_defaultBins = binType.getNumberOfBins();
        this.m_storer = new ThresholdStorer(n, this);
        this.m_stats = new OneDStatisticsProvider(this);
        this.setFillable(new FillableTee(this.m_storer, this.m_stats));
        this.setStatisticsProvider(this.m_stats);
    }

    public AutoPartition(double d, double d2) {
        this(2000, 40, d, d2);
    }

    public AutoPartition(int n, int n2, double d, double d2) {
        this(n, new SimpleBinner(n2), d, d2);
    }

    public AutoPartition(int n, BinType binType, double d, double d2) {
        if (n <= 0) {
            throw new IllegalArgumentException("autoCutoff <= 0");
        }
        this.m_autoCutoff = n;
        this.m_type = binType;
        this.m_thresholdReached = false;
        this.m_autoRange = false;
        this.m_min = d;
        this.m_max = d2;
        this.m_defaultBins = binType.getNumberOfBins();
        this.m_storer = new SimpleStorer();
        this.setFillable(this.m_storer);
    }

    public void setBinning(int n, double d, double d2) {
        if (!this.m_thresholdReached) {
            SimpleBinFinder simpleBinFinder = new SimpleBinFinder(n, d, d2, false);
            SimpleBinner simpleBinner = new SimpleBinner(n);
            BinAdapter binAdapter = new BinAdapter(simpleBinFinder, simpleBinner);
            this.m_storer.fillData(binAdapter);
            this.setDataSource(new SimpleBinnerDataSourceAdapter(simpleBinFinder, simpleBinner));
        }
    }

    public void thresholdReached() {
        System.out.println("Auto Partition Threshold reached");
        if (this.m_autoRange) {
            this.m_min = this.m_stats.getMin();
            this.m_max = this.m_stats.getMax();
            System.out.println("min,max=" + this.m_min + "," + this.m_max);
            SimpleBinFinder simpleBinFinder = new SimpleBinFinder(this.m_defaultBins, this.m_min, this.m_max, false);
            BinAdapter binAdapter = new BinAdapter(simpleBinFinder, this.m_type);
            this.m_storer.fillData(binAdapter);
            this.setDataSource(new SimpleBinnerDataSourceAdapter(simpleBinFinder, this.m_type));
            this.m_stats.setRangeChangeListener(null);
            this.setFillable(new FillableTee(this.m_stats, binAdapter));
            this.m_storer = null;
            this.m_thresholdReached = true;
        } else {
            System.out.println("min,max=" + this.m_min + "," + this.m_max);
            SimpleBinFinder simpleBinFinder = new SimpleBinFinder(this.m_defaultBins, this.m_min, this.m_max, false);
            this.m_stats = new OneDStatisticsProvider();
            this.setStatisticsProvider(this.m_stats);
            FillableTee fillableTee = new FillableTee(this.m_stats, new BinAdapter(simpleBinFinder, this.m_type));
            this.m_storer.fillData(fillableTee);
            this.setDataSource(new SimpleBinnerDataSourceAdapter(simpleBinFinder, this.m_type));
            this.setFillable(fillableTee);
            this.m_storer = null;
            this.m_thresholdReached = true;
        }
    }

    public int getNumberOfBins() {
        return this.m_defaultBins;
    }

    public double getMin() {
        if (!this.m_autoRange || this.m_thresholdReached) {
            return this.m_min;
        }
        return this.m_stats.getMin();
    }

    public double getMax() {
        if (!this.m_autoRange || this.m_thresholdReached) {
            return this.m_max;
        }
        return this.m_stats.getMax();
    }

    public Statistics getStatistics() {
        if (this.m_autoRange || this.m_thresholdReached) {
            return this.m_stats.getStatistics();
        }
        OneDStatisticsProvider oneDStatisticsProvider = new OneDStatisticsProvider();
        this.m_storer.fillData(oneDStatisticsProvider);
        return oneDStatisticsProvider.getStatistics();
    }

    public boolean isRebinnable() {
        return !this.m_thresholdReached;
    }

    public Partition makeCopy() {
        if (this.m_autoRange) {
            return new AutoPartition(this.m_autoCutoff, this.m_defaultBins);
        }
        return new AutoPartition(this.m_autoCutoff, this.m_defaultBins, this.m_min, this.m_max);
    }
}

