/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.NoSuchBinException;
import hep.analysis.Partition;
import hep.analysis.partition.PartitionFillException;
import hep.analysis.partition.PartitionNotification;
import hep.analysis.partition.RangeChangeListener;
import hep.analysis.partition.TwoDDataSource;
import hep.analysis.partition.UnsupportedPartitionMethodException;
import java.io.Serializable;
import java.util.Date;

public abstract class Abstract2DPartition
extends Partition
implements TwoDDataSource {
    static final long serialVersionUID = -4211256413767101846L;
    protected transient boolean m_dataChanged = false;
    protected transient boolean m_xAxisChanged = false;
    protected transient boolean m_yAxisChanged = false;
    protected transient boolean m_dataNotificationSent = false;
    protected transient boolean m_xAxisNotificationSent = false;
    protected transient boolean m_yAxisNotificationSent = false;
    protected transient boolean m_dataFinalChangedNotificationSent = false;
    protected transient boolean m_rangeFinalChangedNotificationSent = false;
    private static final PartitionNotification hx = new PartitionNotification(6, false);
    private static final PartitionNotification hy = new PartitionNotification(6, false);
    private static final PartitionNotification hxy = new PartitionNotification(6, false);
    private static final PartitionNotification hd = new PartitionNotification(2, false);
    private static final PartitionNotification hr = new PartitionNotification(16, false);

    public void fillW(double d, double d2) {
        throw new PartitionFillException(this);
    }

    public void fillW(int n, double d) {
        throw new PartitionFillException(this);
    }

    public void fillW(String string, double d) {
        throw new PartitionFillException(this);
    }

    public void fillW(Date date, double d) {
        throw new PartitionFillException(this);
    }

    public void fill(double d) {
        throw new PartitionFillException(this);
    }

    public void fill(int n) {
        throw new PartitionFillException(this);
    }

    public void fill(String string) {
        throw new PartitionFillException(this);
    }

    public void fill(Date date) {
        throw new PartitionFillException(this);
    }

    public void fill(double d, double d2) {
        throw new PartitionFillException(this);
    }

    public void fillW(double d, double d2, double d3) {
        throw new PartitionFillException(this);
    }

    public void fill(Date date, double d) {
        throw new PartitionFillException(this);
    }

    public void fillW(Date date, double d, double d2) {
        throw new PartitionFillException(this);
    }

    public double getBin(int n, int n2) throws NoSuchBinException {
        try {
            return 0.0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchBinException();
        }
    }

    public boolean isRebinnable() {
        return false;
    }

    public void setXBinning(int n, double d, double d2) {
        throw new UnsupportedPartitionMethodException();
    }

    public void setYBinning(int n, double d, double d2) {
        throw new UnsupportedPartitionMethodException();
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 1;
    }

    public boolean hasAsymmetricErrorBars() {
        return false;
    }

    public boolean hasSimpleQuadraticErrorBars() {
        return false;
    }

    public String[] getXAxisLabels() {
        throw new UnsupportedPartitionMethodException();
    }

    public String[] getYAxisLabels() {
        throw new UnsupportedPartitionMethodException();
    }

    public abstract int getNumberOfXBins();

    public abstract int getNumberOfYBins();

    protected RangeChangeListener getRangeChangeListener(int n) {
        return new TwoDRangeChangeListener(n);
    }

    protected void setBothRangesChanged() {
        this.m_xAxisChanged = true;
        this.m_yAxisChanged = true;
        if (!this.m_xAxisNotificationSent || !this.m_yAxisNotificationSent) {
            this.notifyObservers(hxy);
            this.m_yAxisNotificationSent = true;
            this.m_xAxisNotificationSent = true;
        }
    }

    protected void setXRangeChanged() {
        this.m_xAxisChanged = true;
        if (!this.m_xAxisNotificationSent) {
            this.notifyObservers(hx);
            this.m_xAxisNotificationSent = true;
        }
    }

    protected void setYRangeChanged() {
        this.m_yAxisChanged = true;
        if (!this.m_yAxisNotificationSent) {
            this.notifyObservers(hy);
            this.m_yAxisNotificationSent = true;
        }
    }

    public void setDataChanged() {
        this.m_dataChanged = false;
        if (!this.m_dataNotificationSent) {
            this.notifyObservers(hd);
            this.m_dataNotificationSent = true;
        }
    }

    protected void clearDataChanged() {
        this.m_dataChanged = false;
        this.m_dataNotificationSent = false;
        this.m_dataFinalChangedNotificationSent = false;
    }

    public void clearChanges() {
        this.m_dataChanged = false;
        this.m_yAxisChanged = false;
        this.m_xAxisChanged = false;
        this.m_dataNotificationSent = false;
        this.m_yAxisNotificationSent = false;
        this.m_xAxisNotificationSent = false;
    }

    public void clear() {
        this.setDataAndRangeChangedNow();
    }

    protected final void setDataAndRangeChangedNow() {
        this.m_dataChanged = true;
        this.m_xAxisChanged = true;
        this.m_yAxisChanged = true;
        this.m_dataFinalChangedNotificationSent = false;
        this.m_rangeFinalChangedNotificationSent = false;
        this.done();
    }

    public void done() {
        int n = 0;
        if (this.m_dataChanged && !this.m_dataFinalChangedNotificationSent) {
            n |= 2;
        }
        if ((this.m_xAxisChanged || this.m_yAxisChanged) && !this.m_rangeFinalChangedNotificationSent) {
            n |= 4;
        }
        if (n != 0) {
            PartitionNotification partitionNotification = new PartitionNotification(n, true);
            if (this.m_xAxisChanged) {
                partitionNotification.setAxis(0);
            }
            if (this.m_yAxisChanged) {
                partitionNotification.setAxis(1);
            }
            this.notifyObservers(partitionNotification);
        }
    }

    public final void notifyObservers(Object object) {
        this.setChanged();
        super.notifyObservers(object);
    }

    public abstract double getYMax();

    public abstract double getYMin();

    public abstract double getXMax();

    public abstract double getXMin();

    public abstract double[][] getBins();

    public abstract double[][] getMinusErrors();

    public abstract double[][] getPlusErrors();

    static {
        hx.setAxis(0);
        hy.setAxis(1);
        hxy.setAxis(0);
        hxy.setAxis(1);
    }

    private class TwoDRangeChangeListener
    implements RangeChangeListener,
    Serializable {
        private int axis;
        static final long serialVersionUID = 4238834432795315582L;

        TwoDRangeChangeListener(int n) {
            this.axis = n;
        }

        public void rangeChanged(double d, double d2) {
            if (this.axis == 0) {
                Abstract2DPartition.this.setXRangeChanged();
            } else {
                Abstract2DPartition.this.setYRangeChanged();
            }
        }
    }
}

