/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis.partition;

import hep.analysis.NoSuchBinException;
import hep.analysis.Partition;
import hep.analysis.partition.OneDDataSource;
import hep.analysis.partition.PartitionFillException;
import hep.analysis.partition.PartitionNotification;
import hep.analysis.partition.RangeChangeListener;
import hep.analysis.partition.UnsupportedPartitionMethodException;
import java.util.Date;

public abstract class Abstract1DPartition
extends Partition
implements RangeChangeListener,
OneDDataSource {
    private transient boolean m_dataChanged = false;
    private transient boolean m_rangeChanged = false;
    private transient boolean m_dataChangedNotificationSent = false;
    private transient boolean m_rangeChangedNotificationSent = false;
    private transient boolean m_dataFinalChangedNotificationSent = false;
    private transient boolean m_rangeFinalChangedNotificationSent = false;
    private static final PartitionNotification hd = new PartitionNotification(2, false);
    private static final PartitionNotification hr = new PartitionNotification(4, false);
    private static final PartitionNotification hdr = new PartitionNotification(6, false);
    static final long serialVersionUID = -758403252683365914L;

    public void fillW(double d, double d2) {
        throw new PartitionFillException(this);
    }

    public void fillW(int n, double d) {
        this.fill(n, d);
    }

    public void fillW(String string, double d) {
        throw new PartitionFillException(this);
    }

    public void fillW(Date date, double d) {
        throw new PartitionFillException(this);
    }

    public void fill(double d) {
        this.fillW(d, 1.0);
    }

    public void fill(int n) {
        this.fillW(n, 1.0);
    }

    public void fill(String string) {
        this.fillW(string, 1.0);
    }

    public void fill(Date date) {
        this.fillW(date, 1.0);
    }

    public void fill(double d, double d2) {
        throw new PartitionFillException(this);
    }

    public void fillW(double d, double d2, double d3) {
        throw new PartitionFillException(this);
    }

    public void fill(Date date, double d) {
        throw new PartitionFillException(this);
    }

    public void fillW(Date date, double d, double d2) {
        throw new PartitionFillException(this);
    }

    public int getBinAt(double d) throws NoSuchBinException {
        throw new NoSuchBinException();
    }

    public int getBinAt(int n) throws NoSuchBinException {
        return this.getBinAt((double)n);
    }

    public int getBinAt(String string) throws NoSuchBinException {
        throw new NoSuchBinException();
    }

    public int getBinAt(Date date) throws NoSuchBinException {
        throw new NoSuchBinException();
    }

    public double getBin(int n) throws NoSuchBinException {
        try {
            return this.getBins()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchBinException();
        }
    }

    public boolean hasAsymmetricErrorBars() {
        return false;
    }

    public boolean hasSimpleQuadraticErrorBars() {
        return false;
    }

    public double getPlusError(int n) {
        try {
            return this.getPlusErrors()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchBinException();
        }
    }

    public double getMinusError(int n) {
        try {
            return this.getMinusErrors()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchBinException();
        }
    }

    public double getError(int n) {
        try {
            return this.getPlusErrors()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchBinException();
        }
    }

    public boolean isRebinnable() {
        return false;
    }

    public void setBinning(int n, double d, double d2) {
        throw new UnsupportedPartitionMethodException();
    }

    public String[] getAxisLabels() {
        throw new UnsupportedPartitionMethodException();
    }

    public int getAxisType() {
        return 1;
    }

    public abstract double[] getBins();

    public abstract double[] getPlusErrors();

    public abstract double[] getMinusErrors();

    public abstract int getNumberOfBins();

    public abstract double getMin();

    public abstract double getMax();

    protected final void setDataChanged() {
        this.m_dataChanged = true;
        if (!this.m_dataChangedNotificationSent) {
            this.notifyObservers(hd);
            this.m_dataChangedNotificationSent = true;
        }
    }

    public void rangeChanged(double d, double d2) {
        this.setRangeChanged();
    }

    protected final void setDataAndRangeChanged() {
        this.m_dataChanged = true;
        this.m_rangeChanged = true;
        if (!this.m_dataChangedNotificationSent || !this.m_rangeChangedNotificationSent) {
            this.notifyObservers(hdr);
            this.m_dataChangedNotificationSent = true;
            this.m_rangeChangedNotificationSent = true;
        }
    }

    protected final void setDataAndRangeChangedNow() {
        this.m_dataChanged = true;
        this.m_rangeChanged = true;
        this.m_dataFinalChangedNotificationSent = false;
        this.m_rangeFinalChangedNotificationSent = false;
        this.done();
    }

    protected final void clearDataChanged() {
        this.m_dataChanged = false;
        this.m_dataChangedNotificationSent = false;
        this.m_dataFinalChangedNotificationSent = false;
    }

    protected final void setRangeChanged() {
        this.m_rangeChanged = true;
        if (!this.m_rangeChangedNotificationSent) {
            this.notifyObservers(hr);
            this.m_rangeChangedNotificationSent = true;
        }
    }

    protected final void clearRangeChanged() {
        this.m_rangeChanged = false;
        this.m_rangeChangedNotificationSent = false;
        this.m_rangeFinalChangedNotificationSent = false;
    }

    public void clear() {
        this.setDataAndRangeChangedNow();
    }

    public void done() {
        int n = 0;
        if (this.m_dataChanged && !this.m_dataFinalChangedNotificationSent) {
            this.m_dataFinalChangedNotificationSent = true;
            n |= 2;
        }
        if (this.m_rangeChanged && !this.m_rangeFinalChangedNotificationSent) {
            this.m_rangeFinalChangedNotificationSent = true;
            n |= 4;
        }
        if (n != 0) {
            this.notifyObservers(new PartitionNotification(n, true));
        }
    }

    public final void notifyObservers(Object object) {
        this.setChanged();
        super.notifyObservers(object);
    }
}

