/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis;

import hep.analysis.AbstractNamedObject;
import hep.analysis.Folder;
import hep.analysis.Histogram;
import hep.analysis.PlotFolder;
import hep.analysis.peer.Peer;
import hep.analysis.peer.PlotPeer;
import java.util.Vector;

public class Plot
extends AbstractNamedObject {
    private transient PlotPeer m_peer;
    private Vector m_histograms = new Vector();
    private double m_x;
    private double m_y;
    private double m_width;
    private double m_height;
    static final long serialVersionUID = 796153489222271101L;

    public Plot(String string) {
        this(string, PlotFolder.getDefaultFolder());
    }

    public Plot(String string, Folder folder) {
        super(string, folder);
    }

    public void add(Histogram histogram) {
        if (!this.m_histograms.contains(histogram)) {
            this.m_histograms.addElement(histogram);
            if (this.m_peer != null) {
                this.m_peer.addNotify(histogram);
            }
        }
    }

    public int getNHistograms() {
        return this.m_histograms.size();
    }

    public Histogram getHistogram(int n) {
        return (Histogram)this.m_histograms.elementAt(n);
    }

    public void remove(Histogram histogram) {
        if (this.m_histograms.removeElement(histogram) && this.m_peer != null) {
            this.m_peer.removeNotify(histogram);
        }
    }

    public void clear() {
        if (!this.m_histograms.isEmpty()) {
            this.m_histograms.removeAllElements();
            if (this.m_peer != null) {
                this.m_peer.clearNotify();
            }
        }
    }

    public void show() {
        if (this.m_peer != null) {
            this.m_peer.show();
        }
    }

    void setPeer(Peer peer) {
        this.m_peer = (PlotPeer)peer;
    }

    Peer getPeer() {
        return this.m_peer;
    }

    protected Folder getDefaultParent() {
        return PlotFolder.getDefaultFolder();
    }

    public String toString() {
        return "Plot: " + this.getName();
    }
}

