/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis;

import hep.analysis.AbstractNamedObject;
import hep.analysis.Folder;
import hep.analysis.PageFolder;
import hep.analysis.Plot;
import hep.analysis.peer.PagePeer;
import hep.analysis.peer.Peer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Page
extends AbstractNamedObject {
    private transient PagePeer m_peer;
    private Vector m_plots = new Vector();
    private int m_xGrid = 0;
    private int m_yGrid = 0;
    private boolean hasConstraints;
    static final long serialVersionUID = -6203596861252571247L;

    public Page(String string) {
        this(string, PageFolder.getDefaultFolder());
    }

    public Page(String string, PageFolder pageFolder) {
        super(string, pageFolder);
    }

    public void add(Plot plot) {
        if (this.m_plots.isEmpty()) {
            this.hasConstraints = false;
        } else if (this.hasConstraints) {
            throw new RuntimeException("Cannot mix constrained and unconstrained plots within a page");
        }
        this.m_plots.addElement(plot);
    }

    public void add(Plot plot, double d, double d2, double d3, double d4) {
        if (d < 0.0 || d > 100.0) {
            throw new IllegalArgumentException("x");
        }
        if (d2 < 0.0 || d2 > 100.0) {
            throw new IllegalArgumentException("y");
        }
        if (d3 <= 0.0 || d + d3 > 100.0) {
            throw new IllegalArgumentException("width");
        }
        if (d4 <= 0.0 || d2 + d4 > 100.0) {
            throw new IllegalArgumentException("height");
        }
        if (this.m_plots.isEmpty()) {
            this.hasConstraints = true;
        } else if (!this.hasConstraints) {
            throw new RuntimeException("Cannot mix constrained and unconstrained plots within a page");
        }
        this.m_plots.addElement(new ConstrainedPlot(plot, d, d2, d3, d4));
    }

    public void remove(Plot plot) {
        this.m_plots.removeElement(plot);
    }

    public void removeAll() {
        this.m_plots.removeAllElements();
    }

    public void setGrid(int n, int n2) {
        this.m_xGrid = n;
        this.m_yGrid = n2;
    }

    public void show() {
        if (this.m_peer != null) {
            this.m_peer.show();
        }
    }

    public int getGridX() {
        return this.m_xGrid;
    }

    public int getGridY() {
        return this.m_yGrid;
    }

    public Enumeration plots() {
        return this.m_plots.elements();
    }

    public int getNPlots() {
        return this.m_plots.size();
    }

    void setPeer(Peer peer) {
        this.m_peer = (PagePeer)peer;
    }

    Peer getPeer() {
        return this.m_peer;
    }

    protected Folder getDefaultParent() {
        return PageFolder.getDefaultFolder();
    }

    public String toString() {
        return "Page: " + this.getName();
    }

    public class ConstrainedPlot
    implements Serializable {
        private Plot plot;
        private double x;
        private double y;
        private double width;
        private double height;
        static final long serialVersionUID = 222934009074326407L;

        ConstrainedPlot(Plot plot, double d, double d2, double d3, double d4) {
            this.plot = plot;
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }

        public Plot getPlot() {
            return this.plot;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }
    }
}

