/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis;

import hep.analysis.EventAnalyzer;
import hep.analysis.EventSource;
import hep.analysis.Folder;
import hep.analysis.FolderSet;
import hep.analysis.Histogram;
import hep.analysis.HistogramFolder;
import hep.analysis.HistogramFolderSet;
import hep.analysis.JobError;
import hep.analysis.JobFolder;
import hep.analysis.JobOutputStream;
import hep.analysis.NamedObject;
import hep.analysis.peer.AnalysisApplication;
import hep.analysis.peer.JobPeer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPOutputStream;

public class Job {
    private Hashtable m_folderSets = new Hashtable();
    private Folder m_jobFolder;
    private JobPeer m_peer;
    private static AnalysisApplication theApp;
    private Histogram last;
    private HistogramFolderSet hfs;
    static /* synthetic */ Class class$hep$analysis$HistogramFolderSet;
    static /* synthetic */ Class class$hep$analysis$Job;

    public Job(String string) {
        if (theApp == null) {
            String string2 = System.getProperty("hep.analysis.application", "hep.analysis.standalone.StandAloneApp");
            try {
                theApp = (AnalysisApplication)Class.forName(string2).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JobError("Standalone application not found: " + string2);
            }
            catch (InstantiationException instantiationException) {
                throw new JobError("Could not instantiate standalone application: " + string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JobError("Could not access standalone application: " + string2);
            }
        }
        this.m_peer = theApp.createJobPeer(string, this);
        this.m_jobFolder = new JobFolder(string, this);
        this.m_jobFolder.setPeer(this.m_peer);
    }

    public void setEventSource(EventSource eventSource) {
        this.m_peer.setEventSource(eventSource);
    }

    public void addEventAnalyzer(EventAnalyzer eventAnalyzer) {
        this.m_peer.addEventAnalyzer(eventAnalyzer);
    }

    public void removeEventAnalyzer(EventAnalyzer eventAnalyzer) {
        this.m_peer.removeEventAnalyzer(eventAnalyzer);
    }

    public void removeAllEventAnalyzers() {
        this.m_peer.removeAllEventAnalyzers();
    }

    public void go() {
        this.go(0);
    }

    public void step() {
        this.go(1);
    }

    public void go(int n) {
        this.m_peer.go(n);
    }

    public void rewind() {
        this.m_peer.rewind();
        HistogramFolderSet histogramFolderSet = this.histogramFolderSet(false);
        if (histogramFolderSet != null) {
            ((HistogramFolder)histogramFolderSet.getRootFolder()).rewind();
        }
    }

    public void save() {
        this.save(this.m_jobFolder.getName() + ".javahist");
    }

    public void save(String string) {
        this.save(new File(string));
    }

    public void save(File file) {
        try {
            JobOutputStream jobOutputStream = new JobOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            this.save(jobOutputStream);
            jobOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Error saving job" + iOException.getMessage());
        }
    }

    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.m_jobFolder);
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(this.m_peer.getLogStream());
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        Enumeration enumeration = this.m_folderSets.elements();
        while (enumeration.hasMoreElements()) {
            FolderSet folderSet = (FolderSet)enumeration.nextElement();
            folderSet.dump(printWriter);
        }
    }

    public static Job currentJob() {
        if (theApp == null) {
            new Job("Default Job");
        }
        return theApp.currentJob();
    }

    static void setAnalysisApplication(AnalysisApplication analysisApplication) {
        theApp = analysisApplication;
    }

    JobPeer getPeer() {
        return this.m_peer;
    }

    final Histogram findHistogram(String string) {
        return this.findHistogram(string, (HistogramFolder)this.histogramFolderSet(true).getCurrentFolder());
    }

    final Histogram findHistogram(String string, HistogramFolder histogramFolder) {
        Histogram histogram;
        if (this.last != null && (histogram = this.last.m_nextGuess) != null && histogram.checkGuess(string, histogramFolder)) {
            this.last = histogram;
            return this.last;
        }
        histogram = (Histogram)histogramFolder.find(string);
        if (histogram == null) {
            histogram = new Histogram(string, histogramFolder);
        }
        if (this.last != null) {
            this.last.m_nextGuess = histogram;
        }
        this.last = histogram;
        return this.last;
    }

    HistogramFolderSet histogramFolderSet(boolean bl) {
        if (this.hfs == null && bl) {
            this.hfs = (HistogramFolderSet)this.getFolderSet(class$hep$analysis$HistogramFolderSet == null ? (class$hep$analysis$HistogramFolderSet = Job.class$("hep.analysis.HistogramFolderSet")) : class$hep$analysis$HistogramFolderSet);
        }
        return this.hfs;
    }

    final void done() {
        HistogramFolderSet histogramFolderSet = this.histogramFolderSet(false);
        if (histogramFolderSet != null) {
            ((HistogramFolder)histogramFolderSet.getRootFolder()).done();
        }
    }

    final void resetFolders() {
        Enumeration enumeration = this.m_folderSets.elements();
        while (enumeration.hasMoreElements()) {
            FolderSet folderSet = (FolderSet)enumeration.nextElement();
            folderSet.setCurrentFolder();
        }
    }

    void removeNotify(NamedObject namedObject) {
        Enumeration enumeration = this.m_folderSets.elements();
        while (enumeration.hasMoreElements()) {
            FolderSet folderSet = (FolderSet)enumeration.nextElement();
            if (folderSet.getRootFolder() != namedObject) continue;
            this.m_folderSets.remove(folderSet.getClass());
            if (folderSet != this.hfs) break;
            this.hfs = null;
            break;
        }
    }

    FolderSet getFolderSet(Class clazz) {
        FolderSet folderSet = (FolderSet)this.m_folderSets.get(clazz);
        if (folderSet == null) {
            try {
                Class[] classArray = new Class[]{class$hep$analysis$Job == null ? (class$hep$analysis$Job = Job.class$("hep.analysis.Job")) : class$hep$analysis$Job};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this};
                folderSet = (FolderSet)constructor.newInstance(objectArray);
                this.m_folderSets.put(clazz, folderSet);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Could not create folder set of " + clazz + " :" + invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not create folder set of " + clazz + " :" + exception);
            }
        }
        return folderSet;
    }

    Folder getJobFolder() {
        return this.m_jobFolder;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

