/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis;

import hep.analysis.AbstractNamedObject;
import hep.analysis.Folder;
import hep.analysis.HistogramFolder;
import hep.analysis.Partition;
import hep.analysis.Style;
import hep.analysis.partition.Statistics;
import hep.analysis.peer.HistogramPeer;
import hep.analysis.peer.Peer;
import java.util.Date;

public class Histogram
extends AbstractNamedObject {
    static final long serialVersionUID = -4631743296197770819L;
    private transient HistogramPeer m_peer;
    protected Partition m_partition;
    private Style style;
    private boolean clearOnRewind = true;
    transient Histogram m_nextGuess;

    public Histogram(String string) {
        this(string, HistogramFolder.getDefaultFolder());
    }

    public Histogram(String string, HistogramFolder histogramFolder) {
        this(string, histogramFolder, histogramFolder.getDefaultPartition().makeCopy());
    }

    public Histogram(String string, Partition partition) {
        this(string, HistogramFolder.getDefaultFolder(), partition);
    }

    public Histogram(String string, HistogramFolder histogramFolder, Partition partition) {
        super(string, histogramFolder);
        this.setPartition(partition);
    }

    public void fill(double d) {
        this.m_partition.fill(d);
    }

    public void fillW(double d, double d2) {
        this.m_partition.fillW(d, d2);
    }

    public void fill(int n) {
        this.m_partition.fill(n);
    }

    public void fillW(int n, double d) {
        this.m_partition.fillW(n, d);
    }

    public void fill(String string) {
        this.m_partition.fill(string);
    }

    public void fillW(String string, double d) {
        this.m_partition.fillW(string, d);
    }

    public void fill(Date date) {
        this.m_partition.fill(date);
    }

    public void fillW(Date date, double d) {
        this.m_partition.fillW(date, d);
    }

    public void fill(double d, double d2) {
        this.m_partition.fill(d, d2);
    }

    public void fillW(double d, double d2, double d3) {
        this.m_partition.fillW(d, d2, d3);
    }

    public void fill(Date date, double d) {
        this.m_partition.fill(date, d);
    }

    public void fillW(Date date, double d, double d2) {
        this.m_partition.fillW(date, d, d2);
    }

    public void show() {
        if (this.m_peer != null) {
            this.m_peer.show();
        }
    }

    public void clear() {
        this.m_partition.clear();
    }

    public int getEntries() {
        Statistics statistics = this.m_partition.getStatistics();
        return statistics == null ? 0 : (int)statistics.getStatistic("entries", 0.0);
    }

    public void setPartition(Partition partition) {
        partition.setOwner(this);
        if (this.style != null) {
            partition.setStyle(this.style);
        }
        this.m_partition = partition;
        if (this.m_peer != null) {
            this.m_peer.partitionNotify();
        }
    }

    public void partitionDestroyedNotify() {
        this.m_partition = null;
    }

    public Partition getPartition() {
        return this.m_partition;
    }

    public static Histogram find(String string) {
        return Histogram.find(string, HistogramFolder.getDefaultFolder());
    }

    public static Histogram find(String string, HistogramFolder histogramFolder) {
        Histogram histogram = (Histogram)histogramFolder.find(string);
        if (histogram == null) {
            histogram = new Histogram(string, histogramFolder);
        }
        return histogram;
    }

    Peer getPeer() {
        return this.m_peer;
    }

    void setPeer(Peer peer) {
        this.m_peer = (HistogramPeer)peer;
        if (this.m_partition != null) {
            this.m_peer.partitionNotify();
        }
    }

    public String toString() {
        return "Histogram: " + this.getName() + " (entries=" + this.getEntries() + ")";
    }

    public void setStyle(Style style) {
        this.style = style;
        style.setContainer(((HistogramFolder)this.m_parent).getStyleContainer());
        this.m_partition.setStyle(style);
    }

    public Style getStyle() {
        return this.style;
    }

    protected Folder getDefaultParent() {
        return HistogramFolder.getDefaultFolder();
    }

    public boolean isClearOnRewind() {
        return this.clearOnRewind;
    }

    public void setClearOnRewind(boolean bl) {
        this.clearOnRewind = bl;
    }

    void rewind() {
        if (this.clearOnRewind) {
            this.clear();
        }
    }
}

