/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis;

import hep.analysis.AbstractNamedObject;
import hep.analysis.NamedObject;
import hep.analysis.peer.FolderPeer;
import hep.analysis.peer.Peer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Folder
extends AbstractNamedObject {
    static final long serialVersionUID = -6146292214168028168L;
    private Hashtable m_hash = new Hashtable();
    private transient FolderPeer m_peer;

    Folder(String string) {
        super(string);
    }

    Folder(Folder folder, String string) {
        super(string, folder);
    }

    protected void add(NamedObject namedObject) {
        NamedObject namedObject2 = (NamedObject)this.m_hash.get(namedObject.getName());
        if (namedObject2 != null) {
            namedObject2.delete();
        }
        this.m_hash.put(namedObject.getName(), namedObject);
        if (this.m_peer != null) {
            this.m_peer.addNotify(namedObject);
        }
    }

    protected void remove(NamedObject namedObject) {
        this.m_hash.remove(namedObject.getName());
        if (this.m_peer != null) {
            this.m_peer.removeNotify(namedObject);
        }
    }

    protected void rename(NamedObject namedObject, String string) {
        this.m_hash.remove(string);
        this.m_hash.put(namedObject.getName(), namedObject);
        if (this.m_peer != null) {
            this.m_peer.changeNotify(namedObject, string);
        }
    }

    public NamedObject find(String string) {
        return (NamedObject)this.m_hash.get(string);
    }

    public Folder findSubfolder(String string) {
        try {
            return (Folder)this.m_hash.get(string);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Enumeration getChildren() {
        return this.m_hash.elements();
    }

    Peer getPeer() {
        return this.m_peer;
    }

    void setPeer(Peer peer) {
        this.m_peer = (FolderPeer)peer;
        if (this.m_hash != null) {
            Enumeration enumeration = this.m_hash.elements();
            while (enumeration.hasMoreElements()) {
                this.m_peer.addNotify((NamedObject)enumeration.nextElement());
            }
        }
    }

    void dump(PrintWriter printWriter, String string) {
        if (this.m_hash.isEmpty()) {
            return;
        }
        printWriter.println(string + this.toString());
        Enumeration enumeration = this.m_hash.elements();
        string = string + "   ";
        while (enumeration.hasMoreElements()) {
            NamedObject namedObject = (NamedObject)enumeration.nextElement();
            if (namedObject instanceof Folder) {
                ((Folder)namedObject).dump(printWriter, string);
                continue;
            }
            printWriter.println(string + namedObject.toString());
        }
    }

    public String toString() {
        return "Folder: " + this.getName();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Enumeration enumeration = this.m_hash.elements();
        while (enumeration.hasMoreElements()) {
            AbstractNamedObject abstractNamedObject = (AbstractNamedObject)enumeration.nextElement();
            abstractNamedObject.m_parent = this;
        }
    }
}

