/*
 * Decompiled with CFR 0.152.
 */
package hep.analysis;

import hep.analysis.Folder;
import hep.analysis.HistogramFolder;
import hep.analysis.NamedObject;
import hep.analysis.peer.Peer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;

public abstract class AbstractNamedObject
implements NamedObject,
Serializable {
    static final long serialVersionUID = 8043079859660783625L;
    protected transient Folder m_parent;
    private String m_name;

    AbstractNamedObject(String string) {
        this.m_name = string;
        this.m_parent = null;
    }

    AbstractNamedObject(String string, Folder folder) {
        this.m_name = string;
        this.m_parent = folder;
        folder.add(this);
    }

    public void delete() {
        if (this.m_parent != null) {
            this.m_parent.remove(this);
            this.m_parent = null;
        }
    }

    public void rename(String string) throws NamedObject.RenameException {
        if (this.m_parent != null) {
            if (this.m_parent.find(string) != null) {
                throw new NamedObject.RenameException("Name already in use");
            }
            this.m_parent.remove(this);
            this.m_name = string;
            this.m_parent.add(this);
        } else {
            this.m_name = string;
        }
    }

    boolean checkGuess(String string, HistogramFolder histogramFolder) {
        return string == this.m_name && histogramFolder == this.m_parent;
    }

    public String getName() {
        return this.m_name;
    }

    public Folder getFolder() {
        return this.m_parent;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ObjectInputValidation objectInputValidation = new ObjectInputValidation(){

            public void validateObject() {
                if (AbstractNamedObject.this.m_parent == null) {
                    AbstractNamedObject.this.m_parent = AbstractNamedObject.this.getDefaultParent();
                    if (AbstractNamedObject.this.m_parent != null) {
                        AbstractNamedObject.this.m_parent.add(AbstractNamedObject.this);
                    }
                }
            }
        };
        objectInputStream.registerValidation(objectInputValidation, 0);
    }

    protected abstract Folder getDefaultParent();

    abstract void setPeer(Peer var1);

    abstract Peer getPeer();
}

