/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class SyntaxUtilities {
    private static Color[] COLORS;

    public static boolean regionMatches(boolean bl, Segment segment, int n, String string) {
        char[] cArray;
        int n2 = n + string.length();
        if (n2 > (cArray = segment.array).length) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            char c2 = string.charAt(n4);
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public static boolean regionMatches(boolean bl, Segment segment, int n, char[] cArray) {
        int n2 = n + cArray.length;
        char[] cArray2 = segment.array;
        if (n2 > cArray2.length) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray2[n3];
            char c2 = cArray[n4];
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public static int locateBracketBackward(Document document, int n, char c, char c2) throws BadLocationException {
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = SyntaxUtilities.scanBackwardLine(document.getText(n3, n - n3), c, c2, 0);
        int n5 = -n4 - 1;
        if (n4 >= 0) {
            return n3 + n4;
        }
        int n6 = n2 - 1;
        while (n6 >= 0) {
            element2 = element.getElement(n6);
            n3 = element2.getStartOffset();
            n4 = SyntaxUtilities.scanBackwardLine(document.getText(n3, element2.getEndOffset() - n3), c, c2, n5);
            n5 = -n4 - 1;
            if (n4 >= 0) {
                return n3 + n4;
            }
            --n6;
        }
        return -1;
    }

    public static int locateBracketForward(Document document, int n, char c, char c2) throws BadLocationException {
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = element2.getEndOffset();
        int n5 = SyntaxUtilities.scanForwardLine(document.getText(n + 1, n4 - (n + 1)), c, c2, 0);
        int n6 = -n5 - 1;
        if (n5 >= 0) {
            return n + n5 + 1;
        }
        int n7 = n2 + 1;
        while (n7 < element.getElementCount()) {
            element2 = element.getElement(n7);
            n3 = element2.getStartOffset();
            n5 = SyntaxUtilities.scanForwardLine(document.getText(n3, element2.getEndOffset() - n3), c, c2, n6);
            n6 = -n5 - 1;
            if (n5 >= 0) {
                return n3 + n5;
            }
            ++n7;
        }
        return -1;
    }

    public static Color[] getDefaultSyntaxColors() {
        Color[] colorArray = new Color[11];
        colorArray[1] = Color.red;
        colorArray[2] = new Color(0x990033);
        colorArray[6] = Color.blue;
        colorArray[7] = Color.magenta;
        colorArray[8] = new Color(38400);
        colorArray[3] = new Color(6619289);
        colorArray[4] = new Color(6619289);
        colorArray[5] = new Color(13382399);
        colorArray[9] = Color.orange;
        colorArray[10] = new Color(0xFF9900);
        return colorArray;
    }

    private SyntaxUtilities() {
    }

    private static int scanBackwardLine(String string, char c, char c2, int n) {
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            char c3 = string.charAt(n2);
            if (c3 == c2) {
                ++n;
            } else if (c3 == c && --n < 0) {
                return n2;
            }
            --n2;
        }
        return -1 - n;
    }

    private static int scanForwardLine(String string, char c, char c2, int n) {
        int n2 = 0;
        while (n2 < string.length()) {
            char c3 = string.charAt(n2);
            if (c3 == c) {
                ++n;
            } else if (c3 == c2 && --n < 0) {
                return n2;
            }
            ++n2;
        }
        return -1 - n;
    }
}

