/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class SQLTokenMarker
extends TokenMarker {
    private int offset;
    private int lastOffset;
    private int lastKeyword;
    private int length;
    protected boolean isTSQL = false;
    private KeywordMap keywords;
    private char literalChar = '\u0000';

    public SQLTokenMarker(KeywordMap keywordMap) {
        this(keywordMap, false);
    }

    public SQLTokenMarker(KeywordMap keywordMap, boolean bl) {
        this.keywords = keywordMap;
        this.isTSQL = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte markTokensImpl(byte by, Segment segment, int n) {
        this.lastOffset = this.lastKeyword = segment.offset;
        this.offset = this.lastKeyword;
        this.length = segment.count + this.offset;
        int n2 = this.offset;
        block13: while (n2 < this.length) {
            switch (segment.array[n2]) {
                case '*': {
                    if (by == 1 && this.length - n2 >= 1 && segment.array[n2 + 1] == '/') {
                        by = 0;
                        this.addToken(++n2 + 1 - this.lastOffset, (byte)1);
                        this.lastOffset = n2 + 1;
                        break;
                    }
                    if (by != 0) break;
                    this.searchBack(segment, n2);
                    this.addToken(1, (byte)9);
                    this.lastOffset = n2 + 1;
                    break;
                }
                case '[': {
                    if (by != 0) break;
                    this.searchBack(segment, n2);
                    by = (byte)3;
                    this.literalChar = (char)91;
                    this.lastOffset = n2;
                    break;
                }
                case ']': {
                    if (by != 3 || this.literalChar != '[') break;
                    by = 0;
                    this.literalChar = '\u0000';
                    this.addToken(n2 + 1 - this.lastOffset, (byte)3);
                    this.lastOffset = n2 + 1;
                    break;
                }
                case '(': 
                case ')': 
                case ',': 
                case '.': {
                    if (by != 0) break;
                    this.searchBack(segment, n2);
                    this.addToken(1, (byte)0);
                    this.lastOffset = n2 + 1;
                    break;
                }
                case '%': 
                case '&': 
                case '+': 
                case '<': 
                case '=': 
                case '>': 
                case '^': 
                case '|': 
                case '~': {
                    if (by != 0) break;
                    this.searchBack(segment, n2);
                    this.addToken(1, (byte)9);
                    this.lastOffset = n2 + 1;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (by != 0) break;
                    this.searchBack(segment, n2, false);
                    break;
                }
                case ':': {
                    if (by != 0) break;
                    this.addToken(n2 + 1 - this.lastOffset, (byte)5);
                    this.lastOffset = n2 + 1;
                    break;
                }
                case '/': {
                    if (by != 0) break;
                    if (this.length - n2 >= 2 && segment.array[n2 + 1] == '*') {
                        this.searchBack(segment, n2);
                        by = 1;
                        this.lastOffset = n2++;
                        break;
                    }
                    this.searchBack(segment, n2);
                    this.addToken(1, (byte)9);
                    this.lastOffset = n2 + 1;
                    break;
                }
                case '-': {
                    if (by != 0) break;
                    if (this.length - n2 >= 2 && segment.array[n2 + 1] == '-') {
                        this.searchBack(segment, n2);
                        this.addToken(this.length - n2, (byte)1);
                        this.lastOffset = this.length;
                        break block13;
                    }
                    this.searchBack(segment, n2);
                    this.addToken(1, (byte)9);
                    this.lastOffset = n2 + 1;
                    break;
                }
                case '!': {
                    if (!this.isTSQL || by != 0 || this.length - n2 < 2 || segment.array[n2 + 1] != '=' && segment.array[n2 + 1] != '<' && segment.array[n2 + 1] != '>') break;
                    this.searchBack(segment, n2);
                    this.addToken(1, (byte)9);
                    this.lastOffset = n2 + 1;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (by == 0) {
                        by = (byte)3;
                        this.literalChar = segment.array[n2];
                        this.addToken(n2 - this.lastOffset, (byte)0);
                        this.lastOffset = n2;
                        break;
                    }
                    if (by != 3 || this.literalChar != segment.array[n2]) break;
                    by = 0;
                    this.literalChar = '\u0000';
                    this.addToken(n2 + 1 - this.lastOffset, (byte)3);
                    this.lastOffset = n2 + 1;
                }
            }
            ++n2;
        }
        if (by == 0) {
            this.searchBack(segment, this.length, false);
        }
        if (this.lastOffset != this.length) {
            this.addToken(this.length - this.lastOffset, by);
        }
        return by;
    }

    private void searchBack(Segment segment, int n) {
        this.searchBack(segment, n, true);
    }

    private void searchBack(Segment segment, int n, boolean bl) {
        int n2 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n2);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n2, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n + 1;
        if (bl && this.lastOffset < n) {
            this.addToken(n - this.lastOffset, (byte)0);
        }
    }
}

