/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class DefaultSyntaxDocument
extends PlainDocument
implements SyntaxDocument {
    protected TokenMarker tokenMarker;
    protected Color[] colors = SyntaxUtilities.getDefaultSyntaxColors();

    public DefaultSyntaxDocument() {
        this.addDocumentListener(new DocumentHandler());
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this.tokenMarker = tokenMarker;
        if (tokenMarker == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray;
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int n, int n2) {
        if (this.tokenMarker == null) {
            return;
        }
        Segment segment = new Segment();
        Element element = this.getDefaultRootElement();
        n2 += n;
        try {
            int n3 = n;
            while (n3 < n2) {
                Element element2 = element.getElement(n3);
                int n4 = element2.getStartOffset();
                this.getText(n4, element2.getEndOffset() - n4 - 1, segment);
                this.tokenMarker.markTokens(segment, n3);
                ++n3;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public class DocumentHandler
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            if (DefaultSyntaxDocument.this.tokenMarker == null) {
                return;
            }
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(DefaultSyntaxDocument.this.getDefaultRootElement());
            if (elementChange == null) {
                return;
            }
            DefaultSyntaxDocument.this.tokenMarker.insertLines(elementChange.getIndex() + 1, elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (DefaultSyntaxDocument.this.tokenMarker == null) {
                return;
            }
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(DefaultSyntaxDocument.this.getDefaultRootElement());
            if (elementChange == null) {
                return;
            }
            Element[] elementArray = elementChange.getChildrenRemoved();
            if (elementArray == null) {
                return;
            }
            DefaultSyntaxDocument.this.tokenMarker.deleteLines(elementChange.getIndex() + 1, elementChange.getChildrenRemoved().length - elementChange.getChildrenAdded().length);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

