/*
 * Decompiled with CFR 0.152.
 */
package jas.util.xml;

import jas.util.IndentPrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMLWriter
extends IndentPrintWriter {
    private Hashtable attributes = new Hashtable();
    private Vector openTags = new Vector();

    public XMLWriter(Writer writer) {
        super(writer);
        this.setIndentString("  ");
    }

    public void openTag(String string) {
        this.print("<" + string);
        this.printAttributes(string.length());
        this.println(">");
        this.indent();
        this.openTags.addElement(string);
    }

    public void closeTag() {
        if (this.openTags.isEmpty()) {
            throw new RuntimeException("No open tags");
        }
        Object e = this.openTags.lastElement();
        this.openTags.removeElementAt(this.openTags.size() - 1);
        this.outdent();
        this.print("</");
        this.print(e);
        this.println(">");
    }

    public void printTag(String string) {
        this.print("<" + string);
        this.printAttributes(string.length());
        this.println("/>");
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public void setAttribute(String string, double d) {
        this.setAttribute(string, String.valueOf(d));
    }

    public void setAttribute(String string, int n) {
        this.setAttribute(string, String.valueOf(n));
    }

    public void setAttribute(String string, boolean bl) {
        this.setAttribute(string, String.valueOf(bl));
    }

    private void printAttributes(int n) {
        int n2 = n + 1;
        boolean bl = false;
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this.normalize(this.attributes.get(string).toString());
            int n3 = string.length() + string2.length() + 3;
            if (n2 > 0 && n2 + n3 + 2 * this.getIndent() > 60) {
                n2 = 0;
                this.println();
                if (!bl) {
                    this.indent();
                    bl = true;
                }
            } else {
                n2 += n3;
                this.print(' ');
            }
            this.print(string);
            this.print("=\"");
            this.print(string2);
            this.print("\"");
        }
        this.attributes.clear();
        if (bl) {
            this.outdent();
        }
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

