/*
 * Decompiled with CFR 0.152.
 */
package jas.util.tree;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import jas.util.tree.SimpleNodeListener;
import jas.util.tree.TreeItem;
import jas.util.tree.TreeObjectSource;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleNode {
    private Vector listener;
    private int flags;
    private String name;
    private String type;
    private SimpleNode parent;
    protected FlashVector children;
    protected Object object;
    protected static final Enumeration nullEnumeration = new Vector().elements();

    public SimpleNode() {
        this.flags = 0;
        this.type = null;
        this.parent = null;
        this.name = null;
    }

    public SimpleNode(String string, String string2, int n, Object object) {
        this.parent = null;
        this.name = string;
        this.type = string2;
        this.flags = n;
        this.object = object;
    }

    public SimpleNode(SimpleNode simpleNode, String string, String string2, int n, Object object) {
        this.parent = simpleNode;
        this.name = string;
        this.type = string2;
        this.flags = n;
        this.object = object;
        simpleNode.addChild(this);
    }

    protected SimpleNode createNode(SimpleNode simpleNode, String string, String string2, int n, Object object) {
        return new SimpleNode(simpleNode, string, string2, n, object);
    }

    protected void addChild(SimpleNode simpleNode) {
        if (this.children == null) {
            this.children = new FlashVector();
        }
        this.children.put(simpleNode);
        simpleNode.treeChanged(0);
    }

    protected void removeChild(SimpleNode simpleNode) {
        simpleNode.treeChanged(2);
        this.children.remove(simpleNode);
    }

    protected void renameChild(SimpleNode simpleNode, String string) {
        simpleNode.treeChanged(2);
        this.children.remove(simpleNode);
        simpleNode.name = string;
        this.children.put(simpleNode);
        simpleNode.treeChanged(0);
    }

    protected void treeChanged(int n) {
        SimpleNode simpleNode = this.parent;
        int n2 = 1;
        while (simpleNode != null) {
            if (simpleNode.listener != null) {
                String[] stringArray = new String[n2];
                SimpleNode simpleNode2 = this;
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringArray[n3] = simpleNode2.name;
                    simpleNode2 = simpleNode2.parent;
                    --n3;
                }
                simpleNode.fireTreeChanged(new TreeItem(stringArray, this.type, this.flags | n));
            }
            simpleNode = simpleNode.parent;
            ++n2;
        }
    }

    public TreeItem getTreeItem(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = this;
        int n = 0;
        while (simpleNode2 != simpleNode) {
            simpleNode2 = simpleNode2.parent;
            ++n;
        }
        String[] stringArray = new String[n];
        simpleNode2 = this;
        int n2 = n - 1;
        while (n2 >= 0) {
            stringArray[n2] = simpleNode2.name;
            simpleNode2 = simpleNode2.parent;
            --n2;
        }
        return new TreeItem(stringArray, this.type, this.flags);
    }

    public SimpleNode findChild(String string) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(string);
    }

    public void destroy() {
        this.parent.removeChild(this);
        this.children = null;
    }

    public SimpleNode add(TreeItem treeItem) {
        return this.add(treeItem, null);
    }

    public SimpleNode add(TreeItem treeItem, Object object) {
        SimpleNode simpleNode = this;
        int n = treeItem.path.length;
        int n2 = 0;
        while (n2 < n) {
            String string = treeItem.path[n2];
            SimpleNode simpleNode2 = simpleNode.findChild(string);
            if (simpleNode2 == null) {
                simpleNode = n2 == n - 1 ? this.createNode(simpleNode, string, treeItem.type, treeItem.flags, object) : this.createNode(simpleNode, string, "folder", 4, null);
            } else {
                simpleNode = simpleNode2;
                if (n2 == n - 1) {
                    simpleNode.flags = treeItem.flags;
                }
            }
            ++n2;
        }
        return simpleNode;
    }

    public void remove(TreeItem treeItem) {
        SimpleNode simpleNode = this.find(treeItem);
        if (simpleNode != null) {
            simpleNode.destroy();
        }
    }

    public SimpleNode find(TreeItem treeItem) {
        SimpleNode simpleNode = this;
        int n = treeItem.path.length;
        int n2 = 0;
        while (n2 < n && simpleNode != null) {
            simpleNode = simpleNode.findChild(treeItem.path[n2]);
            ++n2;
        }
        return simpleNode;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public SimpleNode getChild(int n) {
        return this.children.elementAt(n);
    }

    public int getIndexOfChild(Object object) {
        return this.children.indexOf((SimpleNode)object);
    }

    public Enumeration children() {
        if (this.children == null) {
            return nullEnumeration;
        }
        return Collections.enumeration((Collection)this.children.elements());
    }

    public Enumeration elements() {
        return new Enumeration(){
            private Iterator iter;
            {
                this.iter = SimpleNode.this.children.elements().iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return ((SimpleNode)this.iter.next()).object;
            }
        };
    }

    public Object getObject() {
        if (this.object == null) {
            SimpleNode simpleNode = this.parent;
            int n = 1;
            while (simpleNode != null) {
                if (simpleNode.object instanceof TreeObjectSource) {
                    TreeObjectSource treeObjectSource = (TreeObjectSource)simpleNode.object;
                    String[] stringArray = new String[n];
                    SimpleNode simpleNode2 = this;
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        stringArray[n2] = simpleNode2.name;
                        simpleNode2 = simpleNode2.parent;
                        --n2;
                    }
                    TreeItem treeItem = new TreeItem(stringArray, this.type, this.flags);
                    this.object = treeObjectSource.getItem(new TreeItem(stringArray, this.type, this.flags));
                    break;
                }
                simpleNode = simpleNode.parent;
                ++n;
            }
        }
        return this.object;
    }

    public void setFlags(int n) {
        int n2 = this.flags | n;
        if (n2 != this.flags) {
            this.flags = n2;
            this.treeChanged(0);
        }
    }

    public void clearFlags(int n) {
        int n2 = this.flags & ~n;
        if (n2 != this.flags) {
            this.flags = n2;
            this.treeChanged(0);
        }
    }

    public boolean isAncestorOf(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = this;
        while (simpleNode2 != null) {
            if (simpleNode2 == simpleNode) {
                return true;
            }
            simpleNode2 = simpleNode2.parent;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public SimpleNode getParent() {
        return this.parent;
    }

    public void addNodeListener(SimpleNodeListener simpleNodeListener) {
        if (this.listener == null) {
            this.listener = new Vector();
        }
        this.listener.addElement(simpleNodeListener);
    }

    public void removeNodeListener(SimpleNodeListener simpleNodeListener) {
        if (this.listener != null) {
            this.listener.removeElement(simpleNodeListener);
        }
    }

    private void fireTreeChanged(TreeItem treeItem) {
        Enumeration enumeration = this.listener.elements();
        while (enumeration.hasMoreElements()) {
            SimpleNodeListener simpleNodeListener = (SimpleNodeListener)enumeration.nextElement();
            simpleNodeListener.treeChanged(treeItem);
        }
    }

    public String toString() {
        return this.name;
    }

    static class FlashVector {
        private ArrayList vector = new ArrayList();
        private Flash flash;

        FlashVector() {
        }

        void put(SimpleNode simpleNode) {
            this.vector.add((Object)simpleNode);
            if (this.flash != null) {
                this.flash.put(simpleNode.name, this.vector.size() - 1);
            }
        }

        void remove(SimpleNode simpleNode) {
            if (this.flash != null) {
                this.vector.remove(this.flash.get(simpleNode.name));
            } else {
                this.vector.remove((Object)simpleNode);
            }
            this.flash = null;
        }

        SimpleNode get(String string) {
            int n;
            if (this.flash == null) {
                this.fillFlash();
            }
            return (n = this.flash.get(string)) < 0 ? null : (SimpleNode)this.vector.get(n);
        }

        SimpleNode elementAt(int n) {
            return (SimpleNode)this.vector.get(n);
        }

        int indexOf(SimpleNode simpleNode) {
            if (this.flash == null) {
                this.fillFlash();
            }
            return this.flash.get(simpleNode.name);
        }

        int size() {
            return this.vector.size();
        }

        Collection elements() {
            return Collections.unmodifiableCollection((Collection)this.vector);
        }

        private void fillFlash() {
            int n = this.vector.size();
            this.flash = new Flash(n);
            int n2 = 0;
            while (n2 < n) {
                this.flash.put(((SimpleNode)this.vector.get(n2)).name, n2);
                ++n2;
            }
        }

        private class Flash {
            private int[] array;
            private int nentry;
            private int threshold;

            Flash(int n) {
                this.array = new int[Math.max(11, 137 * n / 50)];
                this.nentry = 0;
                this.threshold = this.array.length / 2;
            }

            void put(String string, int n) {
                if (this.nentry++ > this.threshold) {
                    this.rehash();
                }
                int n2 = Math.abs(string.hashCode()) % this.array.length;
                while (this.array[n2] != 0) {
                    n2 = (n2 + 1) % this.array.length;
                }
                this.array[n2] = n + 1;
            }

            private void rehash() {
                int n = this.array.length * 2 + 1;
                int[] nArray = new int[n];
                this.threshold = n / 2;
                int n2 = 0;
                while (n2 < this.array.length) {
                    int n3 = this.array[n2] - 1;
                    if (n3 >= 0) {
                        int n4 = Math.abs(((SimpleNode)FlashVector.this.vector.get(n3)).name.hashCode()) % n;
                        while (nArray[n4] != 0) {
                            n4 = (n4 + 1) % n;
                        }
                        nArray[n4] = n3 + 1;
                    }
                    ++n2;
                }
                this.array = nArray;
            }

            int get(String string) {
                int n = Math.abs(string.hashCode());
                int n2;
                while ((n2 = this.array[n %= this.array.length] - 1) >= 0) {
                    SimpleNode simpleNode = (SimpleNode)FlashVector.this.vector.get(n2);
                    if (simpleNode.name.equals(string)) {
                        return n2;
                    }
                    ++n;
                }
                return -1;
            }
        }
    }
}

