/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.SpinBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public final class FontChooserPanel
extends JPanel {
    private SpinBox m_fontSize;
    private JComboBox m_font = new JComboBox<String>(this.getToolkit().getFontList());
    private JCheckBox m_bold;
    private JCheckBox m_italic;

    public FontChooserPanel(String string, int n, int n2) {
        super(new GridBagLayout());
        this.m_font.setSelectedItem(string);
        this.m_bold = new JCheckBox("Bold", (n & 1) != 0);
        this.m_italic = new JCheckBox("Italic", (n & 2) != 0);
        this.m_bold.setMnemonic('B');
        this.m_italic.setMnemonic('I');
        this.m_fontSize = new SpinBox(n2, 0, 100);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(new JLabel("Font: "));
        jPanel.add(this.m_font);
        this.add((Component)jPanel, gridBagConstraints);
        jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(new JLabel("Font size (points): "));
        jPanel.add(this.m_fontSize);
        this.add((Component)jPanel, gridBagConstraints);
        jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.m_bold);
        jPanel.add(this.m_italic);
        this.add((Component)jPanel, gridBagConstraints);
    }

    public boolean inputIsValid() {
        try {
            return this.getSpecifiedFont() != null;
        }
        catch (Throwable throwable) {
            if (throwable instanceof NumberFormatException) {
                JOptionPane.showMessageDialog(this, "An invalid number was supplied: ".concat(throwable.getMessage()), "Invalid number", 0);
            } else {
                JOptionPane.showMessageDialog(this, "Exception occurred while creating font: ".concat(throwable.toString()), "Invalid font", 0);
            }
            return false;
        }
    }

    public Font getSpecifiedFont() {
        int n = 0;
        if (this.m_bold.isSelected()) {
            n |= 1;
        }
        if (this.m_italic.isSelected()) {
            n |= 2;
        }
        return new Font((String)this.m_font.getSelectedItem(), n, this.m_fontSize.getValue());
    }

    public void addKeyListener(KeyListener keyListener) {
        this.m_fontSize.addKeyListener(keyListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_bold.addChangeListener(changeListener);
        this.m_italic.addChangeListener(changeListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.m_font.addItemListener(itemListener);
    }
}

