/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio.adaptor;

import hep.analysis.NamedObject;
import jas.job.HistogramAccess;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.adaptor.FolderTreeAdaptor;
import jas.util.JASCheckboxMenuItem;
import jas.util.JASCheckboxState;
import jas.util.JASMenuItem;
import javax.swing.JPopupMenu;

public class HistogramFolderTreeAdaptor
extends FolderTreeAdaptor {
    private static JPopupMenu menu;
    private HistogramAccess folder;

    public void init() {
        super.init();
        this.folder = (HistogramAccess)this.getAssociatedObject();
    }

    public void onDelete() {
        this.folder.delete();
    }

    public void onRename() {
        this.startEditing();
    }

    public boolean stopEditing(String string) {
        try {
            this.folder.rename(string);
            return true;
        }
        catch (NamedObject.RenameException renameException) {
            JavaAnalysisStudio.getApp().error("Illegal name", renameException);
            return false;
        }
    }

    public void enableClearOnRewind(JASCheckboxState jASCheckboxState) {
        jASCheckboxState.setEnabled(this.folder.canSetClearOnRewind());
        jASCheckboxState.setCheckbox(this.folder.isClearOnRewind());
    }

    public void onClearOnRewind(boolean bl) {
        this.folder.setClearOnRewind(bl);
    }

    public void onClear() {
        this.folder.clear();
    }

    protected boolean isEditable() {
        return true;
    }

    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = super.getPopupMenu();
            menu.insert(new JASMenuItem("Clear", 'C'), 0);
            menu.insert(new JASCheckboxMenuItem("Clear On Rewind", 'W'), 1);
            menu.insert(new JASMenuItem("Rename", 'R'), 2);
            menu.insert(new JASMenuItem("Delete", 'D'), 3);
        }
        return menu;
    }
}

