/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.InternalFramesWindowManager;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.WindowManager;
import jas.util.JASMenuItem;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class WindowMenu
extends JMenu {
    private WindowManager m_winMan;

    private void buildMenu() {
        this.removeAll();
        int n = this.m_winMan.getWindowCount();
        boolean bl = n > 0;
        WindowMenuItem windowMenuItem = new WindowMenuItem("Close", -1);
        this.add(windowMenuItem);
        windowMenuItem.setEnabled(bl && this.m_winMan.getSelectedWindow() >= 0);
        windowMenuItem.setMnemonic('C');
        windowMenuItem = new WindowMenuItem("Close All", -2);
        this.add(windowMenuItem);
        windowMenuItem.setEnabled(bl);
        windowMenuItem.setMnemonic('A');
        this.addSeparator();
        this.add(new JASMenuItem("Full Screen", 'F'));
        this.addSeparator();
        boolean bl2 = this.m_winMan instanceof InternalFramesWindowManager && bl;
        windowMenuItem = new WindowMenuItem("Cascade", -3);
        this.add(windowMenuItem);
        windowMenuItem.setEnabled(bl2);
        windowMenuItem.setMnemonic('S');
        windowMenuItem = new WindowMenuItem("Tile Horizontally", -4);
        this.add(windowMenuItem);
        windowMenuItem.setEnabled(bl2);
        windowMenuItem.setMnemonic('H');
        windowMenuItem = new WindowMenuItem("Tile Vertically", -5);
        this.add(windowMenuItem);
        windowMenuItem.setEnabled(bl2);
        windowMenuItem.setMnemonic('V');
        if (bl) {
            this.addSeparator();
            int n2 = 0;
            while (n2 < n) {
                this.add(new WindowMenuItem(this.m_winMan.getWindowName(n2), n2));
                ++n2;
            }
        }
    }

    protected void fireMenuSelected() {
        this.m_winMan = JavaAnalysisStudio.getApp().getWindowManager();
        this.buildMenu();
        super.fireMenuSelected();
    }

    private class WindowMenuItem
    extends JMenuItem {
        private int index;

        WindowMenuItem(String string, int n) {
            super(n >= 0 ? String.valueOf(n + 1) + " " + string : string);
            this.index = n;
            if (n >= 0) {
                this.setMnemonic(48 + (char)(n + 1));
            }
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            if (this.index == -2) {
                WindowMenu.this.m_winMan.closeAllWindows();
            } else if (this.index == -1) {
                WindowMenu.this.m_winMan.closeWindow(WindowMenu.this.m_winMan.getSelectedWindow());
            } else if (this.index < 0) {
                ((InternalFramesWindowManager)WindowMenu.this.m_winMan).arrange(this.index);
            } else {
                WindowMenu.this.m_winMan.selectWindow(this.index);
            }
        }
    }
}

