/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import htmllayout.HtmlLayout;
import jas.util.JASDialog;
import jas.util.JASEditableComboBox;
import jas.util.JASState;
import java.awt.Frame;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class WebPageDialog
extends JASDialog
implements ChangeListener {
    private JASEditableComboBox m_text = new JASEditableComboBox("jas.swingstudio.WebPageDialog", 4, true);
    private JCheckBox m_newPage;
    private URL m_url;
    private static final String layout = "<Table rows=2 cols=2><tr><td>URL:<td component=Text horz=MAX><tr><td colspan=2 component=NewPage>";

    WebPageDialog(Frame frame, boolean bl) {
        super(frame, "Open Web Page", true, 13);
        this.m_text.addChangeListener(this);
        this.m_newPage = new JCheckBox("Open in New Page");
        this.m_newPage.setEnabled(bl);
        JPanel jPanel = new JPanel(new HtmlLayout(layout));
        jPanel.add("Text", this.m_text);
        jPanel.add("NewPage", this.m_newPage);
        this.setContentPane(jPanel);
        this.setHelpTopic("userInterface.webPageDialog");
        this.pack();
    }

    protected void onOK() {
        try {
            this.m_url = new URL(this.m_text.getText());
            this.m_text.saveState();
            super.onOK();
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this, "Malformed URL", "Malformed URL", 0);
        }
    }

    protected void enableOK(JASState jASState) {
        jASState.setEnabled(this.m_text.getText().length() > 0);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.callEnable();
    }

    URL getURL() {
        return this.m_url;
    }

    boolean getNewPage() {
        return this.m_newPage.isSelected();
    }
}

