/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RebinSlider
extends JToolBar
implements ChangeListener,
ActionListener {
    private JSlider slider = new JSlider();
    private JTextField text;
    private JComboBox xy;
    private BoundedRangeModel m_model;
    private BoundedRangeModel xModel;
    private BoundedRangeModel yModel;

    public RebinSlider() {
        this.slider.setOrientation(0);
        this.slider.setToolTipText("Rebin Slider");
        this.text = new JTextField(4);
        this.text.setToolTipText("Bins");
        this.text.addActionListener(this);
        this.xy = new JComboBox<String>(new String[]{"X", "Y"});
        this.xy.setToolTipText("Axis Selector");
        this.xy.addActionListener(this);
        this.setState(false);
        this.xy.setEnabled(false);
        this.add(this.slider);
        this.add(this.text);
        this.add(this.xy);
    }

    public void setModel(BoundedRangeModel boundedRangeModel, BoundedRangeModel boundedRangeModel2) {
        this.xModel = boundedRangeModel;
        this.yModel = boundedRangeModel2;
        if (boundedRangeModel != null) {
            this.setModel(boundedRangeModel);
            this.xy.setSelectedIndex(0);
        } else if (boundedRangeModel2 != null) {
            this.setModel(boundedRangeModel2);
            this.xy.setSelectedIndex(1);
        }
        this.xy.setEnabled(boundedRangeModel != null && boundedRangeModel2 != null);
        this.setState(boundedRangeModel != null || boundedRangeModel2 != null);
    }

    private void setModel(BoundedRangeModel boundedRangeModel) {
        if (boundedRangeModel != null) {
            this.slider.setModel(boundedRangeModel);
            this.text.setText(String.valueOf(boundedRangeModel.getValue()));
        }
        if (this.m_model != null) {
            this.m_model.removeChangeListener(this);
        }
        this.m_model = boundedRangeModel;
        if (this.m_model != null) {
            this.m_model.addChangeListener(this);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.text.setText(String.valueOf(this.m_model.getValue()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.text) {
            try {
                this.m_model.setValue(Integer.parseInt(this.text.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.xy) {
            int n = this.xy.getSelectedIndex();
            if (n == 0) {
                this.setModel(this.xModel);
            } else {
                this.setModel(this.yModel);
            }
        }
    }

    private void setState(boolean bl) {
        this.slider.setEnabled(bl);
        this.text.setEnabled(bl);
    }
}

