/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.Cut;
import jas.swingstudio.CutsManager;
import jas.swingstudio.JASJob;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.ProgramPage;
import jas.swingstudio.ProgramTextArea;
import jas.swingstudio.TreeAdaptorSite;
import jas.util.FileTypeFileFilter;
import jas.util.Finishable;
import jas.util.HasHelpPage;
import jas.util.HasNextPages;
import jas.util.JASDialog;
import jas.util.JASTextField;
import jas.util.JASWizardPage;
import jas.util.ReservedWordBin;
import jas.util.UserProperties;
import jas.util.WrappingTextArea;
import jas.util.tree.TreeItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class NewProgramPage
extends JASWizardPage
implements ActionListener,
HasNextPages,
HasHelpPage {
    private EventGeneratorPage m_generatorPage;
    private EventAnalyzerPage m_analyzerPage = null;
    private EventSourceSelectionPage m_selPage = null;
    private Field[] m_fields;
    private JASTextField m_classNameField;
    private String m_className;
    private String m_eventSourceName;
    private JRadioButton m_analyzerButton;
    private JRadioButton m_generatorButton;
    private int m_selected;
    static final int ANALYZER = 0;
    static final int GENERATOR = 1;
    private final String m_opening = "import hep.analysis.*;\nfinal public class ";
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private final String m_tab = "\t";
    private final UserProperties m_prop = this.m_app.getUserProperties();
    private final String m_lastEventHandlerClass_Key = "LastEventHandlerClass";
    private ReservedWordBin m_resBin;
    private final String m_optionalMethodComment = "// Enter code here or delete method definition.\n";
    private final CutsManager m_cutsManager = new CutsManager();
    private String m_eventDataClassName = null;
    static /* synthetic */ Class class$hep$analysis$NTupleEventData;

    NewProgramPage() {
        this(-1);
    }

    NewProgramPage(int n) {
        super(new FlowLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", new JLabel("Enter the name for your class: "));
        this.m_classNameField = new JASTextField(15);
        this.m_classNameField.addKeyListener(this);
        jPanel.add("South", this.m_classNameField);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_selected = n == -1 ? this.m_prop.getInteger("LastEventHandlerClass", 0) : n;
        this.m_analyzerButton = new JRadioButton("EventAnalyzer (for data analysis)", this.m_selected == 0);
        this.m_analyzerButton.addActionListener(this);
        this.m_analyzerButton.setMnemonic('A');
        buttonGroup.add(this.m_analyzerButton);
        this.m_generatorButton = new JRadioButton("EventGenerator (for event simulation)", this.m_selected == 1);
        this.m_generatorButton.addActionListener(this);
        this.m_generatorButton.setMnemonic('G');
        buttonGroup.add(this.m_generatorButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", this.m_analyzerButton);
        jPanel2.add("South", this.m_generatorButton);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Select the class to extend"));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel);
        jPanel3.add("Center", jPanel2);
        WrappingTextArea wrappingTextArea = new WrappingTextArea("This wizard will create a new program page suited to you task.  It will create a class with the name that you specify below and will offer to save the file under that name once you have finished selecting the style you want to have.  You must supply a legal java identifier for the class name.  The 'Next' button will not enable unless text is entered.", false, this.getBackground(), new Dimension(400, 100));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(wrappingTextArea);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add("North", jPanel4);
        jPanel5.add("Center", jPanel3);
        this.add(jPanel5);
    }

    public void beforeShowing() {
        this.m_classNameField.requestFocus();
    }

    public JASWizardPage getNext() {
        this.m_className = this.m_classNameField.getText();
        if (!this.isLegalIdentifier(this.m_className)) {
            JOptionPane.showMessageDialog(this, this.m_className.concat(" is not a legal identifier."), "Error...", 0);
            return null;
        }
        this.m_prop.setInteger("LastEventHandlerClass", this.m_selected);
        if (this.m_selected == 0) {
            if (this.m_analyzerPage != null) {
                return this.m_analyzerPage;
            }
            return this.m_selPage;
        }
        return this.m_generatorPage;
    }

    protected boolean getNextEnabled() {
        this.m_className = this.m_classNameField.getText();
        return this.m_className != null && this.m_className.length() > 0;
    }

    public String getHelpTopic() {
        return "userInterface.programPageWizard.openingPage";
    }

    private boolean isLegalIdentifier(String string) {
        if (string == null) {
            return false;
        }
        if (this.m_resBin == null) {
            this.m_resBin = new ReservedWordBin();
        }
        if (this.m_resBin.isReservedWord(string)) {
            return false;
        }
        int n = string.length();
        int n2 = 1;
        while (n2 < n) {
            if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return n > 0 && Character.isJavaIdentifierStart(string.charAt(0));
    }

    public JASWizardPage[] getNextWizardPages() {
        JASWizardPage[] jASWizardPageArray = new JASWizardPage[2];
        this.m_generatorPage = new EventGeneratorPage();
        jASWizardPageArray[0] = this.m_generatorPage;
        JASJob jASJob = this.m_app.getJob();
        if (jASJob != null) {
            ComboBoxModel comboBoxModel = jASJob.getComboModel();
            if (comboBoxModel.getSize() > 1) {
                this.m_selPage = new EventSourceSelectionPage(comboBoxModel, jASJob.getListRenderer());
                jASWizardPageArray[1] = this.m_selPage;
                return jASWizardPageArray;
            }
            this.m_fields = this.getFields(comboBoxModel, 0);
            this.m_analyzerPage = new EventAnalyzerPage(this.m_fields != null && this.m_fields.length > 0);
        } else {
            this.m_analyzerPage = new EventAnalyzerPage(false);
        }
        jASWizardPageArray[1] = this.m_analyzerPage;
        return jASWizardPageArray;
    }

    private Field[] getFields(ComboBoxModel comboBoxModel, int n) {
        try {
            TreeAdaptorSite treeAdaptorSite = (TreeAdaptorSite)comboBoxModel.getElementAt(n);
            this.m_eventSourceName = treeAdaptorSite.getName();
            Class clazz = this.m_app.getJob().getJob().getEventDataClass(treeAdaptorSite.getTreeItem());
            if (!(class$hep$analysis$NTupleEventData == null ? (class$hep$analysis$NTupleEventData = NewProgramPage.class$("hep.analysis.NTupleEventData")) : class$hep$analysis$NTupleEventData).isAssignableFrom(clazz)) {
                this.m_eventDataClassName = clazz.getName();
                return null;
            }
            Enumeration enumeration = treeAdaptorSite.children();
            Field[] fieldArray = new Field[treeAdaptorSite.getChildCount()];
            int n2 = 0;
            while (n2 < fieldArray.length) {
                TreeItem treeItem = ((TreeAdaptorSite)enumeration.nextElement()).getTreeItem();
                fieldArray[n2] = new Field(treeItem.path[treeItem.path.length - 1], treeItem.type);
                ++n2;
            }
            return fieldArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
        this.m_selected = jRadioButton == this.m_analyzerButton ? 0 : 1;
    }

    private void finish(String string) {
        ProgramPage programPage = new ProgramPage();
        programPage.setText(string);
        programPage.setClassName(this.m_className);
        this.m_app.getWindowManager().newWindow(this.m_className + "     ", programPage);
        this.dispose();
        JFileChooser jFileChooser = new JFileChooser(this.m_app.getUserProperties().getString("LastProgramPath", System.getProperty("user.home")));
        jFileChooser.setSelectedFile(new File(this.m_className.concat(".java")));
        jFileChooser.setFileFilter(new FileTypeFileFilter("java", "Java File (*.java)"));
        jFileChooser.setDialogTitle("Save Source File As...");
        if (jFileChooser.showSaveDialog(this) == 0) {
            try {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().endsWith(".java")) {
                    file = new File(file.getAbsolutePath().concat(".java"));
                }
                this.m_app.getWindowManager().setCurrentTitle(file.getName());
                this.m_app.getUserProperties().setString("LastProgramPath", file.getParent());
                FileWriter fileWriter = new FileWriter(file);
                programPage.getText().write(fileWriter);
                fileWriter.close();
                programPage.setFile(file);
                this.m_app.updateRecentFiles(file);
                if (this.m_resBin != null) {
                    this.m_resBin.dispose();
                }
            }
            catch (IOException iOException) {
                this.m_app.error("Could not save job", iOException);
            }
        }
    }

    private boolean declareDataViews(StringBuffer stringBuffer, HistogramsPanel histogramsPanel, IdentifierMonitor identifierMonitor) throws IdentifierException {
        String string;
        StringTokenizer stringTokenizer = histogramsPanel.getHistograms();
        boolean bl = stringTokenizer.hasMoreTokens();
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            identifierMonitor.registerUserIdentifier(string);
            stringBuffer.append("\tfinal private Histogram " + string + " = new Histogram(\"" + string + "\");\n");
        }
        stringTokenizer = histogramsPanel.getScatterPlots();
        boolean bl2 = stringTokenizer.hasMoreTokens();
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            identifierMonitor.registerUserIdentifier(string);
            stringBuffer.append("\tfinal private ScatterPlot " + string + " = new ScatterPlot(\"" + string + "\");\n");
        }
        if (bl || bl2) {
            stringBuffer.append("\t// To group these ");
            if (bl) {
                stringBuffer.append("histograms");
                if (bl2) {
                    stringBuffer.append(" and ");
                }
            }
            if (bl2) {
                stringBuffer.append("plots");
            }
            stringBuffer.append(" into folders,\n\t// declare some variables of type HistogramFolder,\n\t// initialize those folders in the consructor, and\n\t// pass the appropriate folder to the Histogram and\n\t// ScatterPlot constructors.\n\n");
            return true;
        }
        return false;
    }

    private void fillDataViews(StringBuffer stringBuffer, HistogramsPanel histogramsPanel) {
        StringTokenizer stringTokenizer = histogramsPanel.getHistograms();
        boolean bl = stringTokenizer.hasMoreTokens();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\t\t" + stringTokenizer.nextToken() + ".fill(" + "  ); // Enter calculation for this histogram here.\n");
        }
        stringTokenizer = histogramsPanel.getScatterPlots();
        boolean bl2 = stringTokenizer.hasMoreTokens();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\t\t" + stringTokenizer.nextToken() + ".fill(" + " , ); // Enter calculation for this scatter plot here.\n");
        }
        if (!bl && !bl2) {
            stringBuffer.append("\t\t// Fill histograms and/or scatter plots here.\n");
        }
    }

    public void onCancel() {
        if (this.m_resBin != null) {
            this.m_resBin.dispose();
        }
    }

    private void declareCuts(StringBuffer stringBuffer, IdentifierMonitor identifierMonitor) throws IdentifierException {
        Enumeration enumeration = this.m_cutsManager.elements();
        boolean bl = enumeration.hasMoreElements();
        while (enumeration.hasMoreElements()) {
            Cut cut = (Cut)enumeration.nextElement();
            identifierMonitor.registerUserIdentifier(cut.m_name);
            stringBuffer.append("\tfinal private " + cut.m_type + " " + cut.m_name + " = new " + cut.m_constructor + ";\n");
        }
        if (bl) {
            stringBuffer.append('\n');
        }
    }

    private void addOpening(StringBuffer stringBuffer) {
        stringBuffer.append("// This file has been automatically generated by\n");
        stringBuffer.append("// the Java Analysis Studio program page wizard\n");
        if (this.m_eventSourceName != null) {
            stringBuffer.append("// for the event source named\n");
            stringBuffer.append("// " + this.m_eventSourceName + '\n');
        }
        stringBuffer.append("// " + new Date().toString() + '\n');
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Field[] access$1702(NewProgramPage newProgramPage, Field[] fieldArray) {
        newProgramPage.m_fields = fieldArray;
        return fieldArray;
    }

    private final class PreviewButton
    extends JButton {
        Previewable m_previewable;
        Frame m_frame;
        Component m_component;

        PreviewButton(Previewable previewable, Container container) {
            super("Show preview of selected option");
            this.setMnemonic('S');
            this.m_previewable = previewable;
            this.m_component = container;
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            if (this.m_frame == null) {
                while (!(this.m_component instanceof Frame)) {
                    this.m_component = this.m_component.getParent();
                }
                this.m_frame = (Frame)this.m_component;
            }
            JASDialog jASDialog = new JASDialog(this.m_frame, "Example output", false, 1);
            jASDialog.setOKLabel("Close");
            jASDialog.setOKMnemonic('C');
            JScrollPane jScrollPane = new JScrollPane();
            String string = this.m_previewable.generateText();
            if (string == null) {
                return;
            }
            ProgramTextArea programTextArea = new ProgramTextArea(false);
            programTextArea.setText(string);
            jScrollPane.setViewportView(programTextArea);
            jASDialog.setContentPane(jScrollPane);
            jASDialog.pack();
            jASDialog.show();
        }
    }

    private static interface Previewable {
        public String generateText();
    }

    private final class HistogramsPanel
    extends JPanel {
        private final JASTextField m_histograms = new JASTextField(15);
        private final JASTextField m_scatterPlots = new JASTextField(15);

        HistogramsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets.bottom = 2;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.left = 2;
            gridBagConstraints.insets.right = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)new JLabel("Enter names for histograms to create:"), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)new JLabel("Enter names for scatter plots to create:"), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.m_histograms, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.m_scatterPlots, gridBagConstraints);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            this.add((Component)new JLabel("* Enter legal Java identifiers separated with spaces."), gridBagConstraints);
            this.setBorder(new EtchedBorder());
        }

        StringTokenizer getHistograms() {
            return new StringTokenizer(this.m_histograms.getText());
        }

        StringTokenizer getScatterPlots() {
            return new StringTokenizer(this.m_scatterPlots.getText());
        }
    }

    private final class EventAnalyzerPage
    extends JASWizardPage
    implements ActionListener,
    Finishable,
    Previewable,
    HasHelpPage {
        private JPanel m_variableAccessPanel;
        private final char m_replacementChar = (char)95;
        private JRadioButton m_memberButton;
        private JRadioButton m_wrapperButton;
        private JRadioButton m_defaultButton;
        private JButton m_selectAll;
        private JButton m_selectNone;
        private final byte m_member = 0;
        private final byte m_wrapper = 1;
        private final byte m_default = (byte)2;
        private byte m_selected = 1;
        private HistogramsPanel m_histPanel;
        private SelectableList m_variables;
        private boolean m_dataSetOpen = true;
        private boolean m_optionsShowing;
        private final String m_lastDataAccessStyle_Key = "LastDataAccessStyle";

        EventAnalyzerPage(boolean bl) {
            super(new BorderLayout());
            this.m_histPanel = new HistogramsPanel();
            this.add("North", this.m_histPanel);
            this.m_variableAccessPanel = new JPanel(new BorderLayout());
            this.m_optionsShowing = bl;
            if (bl) {
                this.makeVariableAccessPanelShowOptions();
            } else {
                this.makeVariableAccessPanelShowNoOptions();
                this.m_dataSetOpen = false;
            }
            this.m_variableAccessPanel.setBorder(BorderFactory.createTitledBorder("Select how to access the job's event data"));
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("Edit list of Cuts");
            jButton.addActionListener(NewProgramPage.this.m_cutsManager);
            jButton.setEnabled(false);
            jPanel.add(jButton);
            jPanel.add(new PreviewButton(this, this));
            this.add("South", jPanel);
            this.add("Center", this.m_variableAccessPanel);
        }

        private void makeVariableAccessPanelShowNoOptions() {
            this.m_variableAccessPanel.removeAll();
            this.m_variableAccessPanel.add("Center", new WrappingTextArea("Because no data set is currently open, or the selected data set does not specify column names, you cannot specify a wizard-generated data access style.  A default definition for processEvent() will be included in the output source file.", false, this.getBackground(), new Dimension()));
            this.validate();
        }

        private void makeVariableAccessPanelShowOptions() {
            ButtonGroup buttonGroup = new ButtonGroup();
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.m_selected = (byte)NewProgramPage.this.m_prop.getInteger("LastDataAccessStyle", 2);
            this.m_memberButton = new JRadioButton("Have member variables set to values of selected variables for each event.", this.m_selected == 0);
            buttonGroup.add(this.m_memberButton);
            this.m_memberButton.addActionListener(this);
            this.m_memberButton.setMnemonic('m');
            jPanel2.add("West", this.m_memberButton);
            this.m_variables = new SelectableList();
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            this.m_selectAll = new JButton("Select all");
            this.m_selectAll.setMnemonic('l');
            this.m_selectAll.addActionListener(this.m_variables);
            this.m_selectAll.setEnabled(this.m_selected == 0);
            this.m_selectNone = new JButton("Select none");
            this.m_selectNone.setMnemonic('e');
            this.m_selectNone.addActionListener(this.m_variables);
            this.m_selectNone.setEnabled(this.m_selected == 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            jPanel3.add((Component)this.m_selectAll, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            jPanel3.add((Component)this.m_selectNone, gridBagConstraints);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add("Center", this.m_variables);
            jPanel4.add("East", jPanel3);
            jPanel4.setBorder(BorderFactory.createEtchedBorder());
            jPanel2.add("South", jPanel4);
            jPanel.add("North", jPanel2);
            this.m_wrapperButton = new JRadioButton("Use a wrapper class that makes all variables accessible through convenience methods.", this.m_selected == 1);
            this.m_wrapperButton.setMnemonic('w');
            jPanel.add("Center", this.m_wrapperButton);
            buttonGroup.add(this.m_wrapperButton);
            this.m_wrapperButton.addActionListener(this);
            this.m_defaultButton = new JRadioButton("Use normal event data access.", this.m_selected == 2);
            this.m_defaultButton.setMnemonic('o');
            this.m_defaultButton.addActionListener(this);
            jPanel.add("South", this.m_defaultButton);
            buttonGroup.add(this.m_defaultButton);
            this.m_variableAccessPanel.add("North", jPanel);
        }

        public void beforeShowing() {
            if (NewProgramPage.this.m_fields == null) {
                this.makeVariableAccessPanelShowNoOptions();
                this.m_optionsShowing = false;
            } else {
                if (!this.m_optionsShowing) {
                    this.m_optionsShowing = true;
                    this.makeVariableAccessPanelShowOptions();
                }
                if (this.m_variables != null) {
                    this.m_variables.init(NewProgramPage.this.m_fields);
                    this.m_variables.setEnabled(this.m_selected == 0);
                }
            }
        }

        public String getHelpTopic() {
            return "userInterface.programPageWizard.eventAnalyzerPage";
        }

        public void onFinish() {
            NewProgramPage.this.m_prop.setInteger("LastDataAccessStyle", this.m_selected);
            String string = this.generateText();
            if (string == null) {
                return;
            }
            NewProgramPage.this.finish(string);
        }

        public String generateText() {
            IdentifierMonitor identifierMonitor = new IdentifierMonitor();
            try {
                String string;
                Object object;
                StringBuffer stringBuffer = new StringBuffer(400);
                NewProgramPage.this.addOpening(stringBuffer);
                stringBuffer.append("import hep.analysis.*;\nfinal public class " + NewProgramPage.this.m_className + " extends EventAnalyzer\n{\n");
                boolean bl = NewProgramPage.this.declareDataViews(stringBuffer, this.m_histPanel, identifierMonitor);
                NewProgramPage.this.declareCuts(stringBuffer, identifierMonitor);
                if (this.m_dataSetOpen && this.m_selected == 0 && this.m_variables.someSelected()) {
                    object = this.m_variables.selectedIndexes();
                    int n = 0;
                    while (n < ((int[])object).length) {
                        identifierMonitor.registerWizardIdentifier(((NewProgramPage)NewProgramPage.this).m_fields[object[n]].name);
                        identifierMonitor.registerWizardIdentifier(((NewProgramPage)NewProgramPage.this).m_fields[object[n]].name.concat("_columnIndex"));
                        stringBuffer.append("\tprivate " + this.toJavaType(((NewProgramPage)NewProgramPage.this).m_fields[object[n]].type) + " " + ((NewProgramPage)NewProgramPage.this).m_fields[object[n]].name + ";\n" + "\t" + "private int " + ((NewProgramPage)NewProgramPage.this).m_fields[object[n]].name + "_columnIndex = -1;\n");
                        ++n;
                    }
                    identifierMonitor.registerWizardIdentifier("columnsInitialized");
                    stringBuffer.append("\tprivate boolean columnsInitialized = false;\n\n");
                } else if (this.m_dataSetOpen && this.m_selected == 1) {
                    identifierMonitor.registerWizardIdentifier("data");
                    identifierMonitor.registerClass("DataWrapper");
                    stringBuffer.append("\tfinal private DataWrapper data = new DataWrapper();\n\n");
                }
                stringBuffer.append("\tpublic " + NewProgramPage.this.m_className + "()\n" + "\t" + "{\n");
                object = this.m_histPanel.getHistograms();
                String string2 = "// Enter constructor code here.\n";
                stringBuffer.append("\t\t" + string2 + "\t" + "}\n" + "\t" + "public void beforeFirstEvent()\n" + "\t" + "{\n");
                stringBuffer.append("\t\t// Enter code here or delete method definition.\n");
                stringBuffer.append("\t}\n\tpublic void afterLastEvent()\n\t{\n\t\t// Enter code here or delete method definition.\n\t}\n\tpublic void processEvent(final EventData d)\n\t{\n");
                if (this.m_dataSetOpen && this.m_selected == 0 && this.m_variables.someSelected()) {
                    int[] nArray = this.m_variables.selectedIndexes();
                    stringBuffer.append("\t\tfinal NTupleEventData nTupleData = (NTupleEventData) d;\n\t\tif (!columnsInitialized)\n\t\t{\n");
                    int n = 0;
                    while (n < nArray.length) {
                        String string3 = ((NewProgramPage)NewProgramPage.this).m_fields[nArray[n]].name;
                        stringBuffer.append("\t\t\t" + this.convertToLegalJava(string3).concat("_columnIndex") + " = nTupleData.findColumn(\"" + string3 + "\");\n");
                        ++n;
                    }
                    stringBuffer.append("\t\t\tcolumnsInitialized = true;\n\t\t}\n\n");
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        string = this.convertToLegalJava(((NewProgramPage)NewProgramPage.this).m_fields[nArray[n2]].name);
                        stringBuffer.append("\t\t" + string + " =" + this.toCast(((NewProgramPage)NewProgramPage.this).m_fields[nArray[n2]].type) + "nTupleData." + this.getMethodName(((NewProgramPage)NewProgramPage.this).m_fields[nArray[n2]].type) + "(" + string.concat("_columnIndex") + ");\n");
                        ++n2;
                    }
                    stringBuffer.append("\n");
                } else if (this.m_dataSetOpen && this.m_selected == 1) {
                    stringBuffer.append("\t\tdata.eventData = (NTupleEventData) d;\n\t\tprocessEvent();\n\t}\n\tprivate void processEvent()\n\t{\n\t\t// Use convenience methods in object data\n\t\t// to access event data.\n\n");
                } else if (NewProgramPage.this.m_eventDataClassName != null) {
                    stringBuffer.append("\t\tfinal " + NewProgramPage.this.m_eventDataClassName + " data = " + '(' + NewProgramPage.this.m_eventDataClassName + ") d;\n\n");
                }
                NewProgramPage.this.fillDataViews(stringBuffer, this.m_histPanel);
                stringBuffer.append("\t}\n");
                if (this.m_dataSetOpen && this.m_selected == 1) {
                    stringBuffer.append("\tfinal private class DataWrapper\n\t{\n\t\tNTupleEventData eventData;\n");
                    int n = 0;
                    while (n < NewProgramPage.this.m_fields.length) {
                        String string4 = ((NewProgramPage)NewProgramPage.this).m_fields[n].name;
                        String string5 = this.convertToLegalJava(string4);
                        string = string5.concat("_columnIndex");
                        identifierMonitor.registerWizardIdentifier(string);
                        stringBuffer.append("\n\t\tprivate int " + string + " = -1;\n" + "\t" + "\t" + this.toJavaType(((NewProgramPage)NewProgramPage.this).m_fields[n].type) + " get" + string5 + "()\n" + "\t" + "\t" + "{\n" + "\t" + "\t" + "\t" + "if (" + string + " < 0)\n" + "\t" + "\t" + "\t" + "\t" + string + " = eventData.findColumn(\"" + string4 + "\");\n" + "\t" + "\t" + "\t" + "return" + this.toCast(((NewProgramPage)NewProgramPage.this).m_fields[n].type) + "eventData." + this.getMethodName(((NewProgramPage)NewProgramPage.this).m_fields[n].type) + '(' + string + ");\n" + "\t" + "\t" + "}\n");
                        ++n;
                    }
                    stringBuffer.append("\t}\n");
                }
                stringBuffer.append("}");
                return stringBuffer.toString();
            }
            catch (IdentifierException identifierException) {
                return null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            this.m_selected = jRadioButton == this.m_defaultButton ? (byte)2 : (jRadioButton == this.m_memberButton ? (byte)0 : 1);
            boolean bl = this.m_selected == 0;
            this.m_variables.setEnabled(bl);
            this.m_selectAll.setEnabled(bl);
            this.m_selectNone.setEnabled(bl);
        }

        private String toJavaType(String string) {
            if (string.equals("integer")) {
                return "int";
            }
            if (string.equals("float")) {
                return "double";
            }
            if (string.equals("string")) {
                return "String";
            }
            if (string.equals("boolean")) {
                return "boolean";
            }
            if (string.equals("date")) {
                return "java.util.Date";
            }
            if (string.equals("time")) {
                return "java.util.Date";
            }
            if (string.indexOf(46) >= 0) {
                return string;
            }
            return "Object";
        }

        private String toCast(String string) {
            if (string.indexOf(46) >= 0) {
                return " (" + string + ") ";
            }
            return " ";
        }

        private String getMethodName(String string) {
            if (string.equals("integer")) {
                return "getInt";
            }
            if (string.equals("float")) {
                return "getDouble";
            }
            if (string.equals("string")) {
                return "getString";
            }
            if (string.equals("boolean")) {
                return "getBoolean";
            }
            if (string.equals("date")) {
                return "getDate";
            }
            if (string.equals("time")) {
                return "getDate";
            }
            if (string.indexOf(46) >= 0) {
                return "getObject";
            }
            return "getObject";
        }

        private String convertToLegalJava(String string) {
            if (NewProgramPage.this.m_resBin == null) {
                NewProgramPage.this.m_resBin = new ReservedWordBin();
            }
            if (NewProgramPage.this.m_resBin.isReservedWord(string)) {
                return string.concat("_field");
            }
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            boolean bl = false;
            if (!Character.isJavaIdentifierStart(cArray[0])) {
                cArray[0] = 95;
                bl = true;
            }
            int n = 1;
            while (n < cArray.length) {
                if (!Character.isJavaIdentifierPart(cArray[n])) {
                    cArray[n] = 95;
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                string = new String(cArray);
            }
            return string;
        }

        private final class SelectableList
        extends JScrollPane
        implements ActionListener {
            private JCheckBox[] m_boxes;
            private int m_nSelected;

            SelectableList() {
                this.setPreferredSize(new Dimension(300, 120));
                this.setColumnHeaderView(new JLabel("Select the data set(s) you wish to access:"));
            }

            void init(Field[] fieldArray) {
                JPanel jPanel = new JPanel(new GridLayout(fieldArray.length, 1, 0, 0));
                this.setViewportView(jPanel);
                this.m_nSelected = fieldArray.length;
                this.m_boxes = new JCheckBox[this.m_nSelected];
                int n = 0;
                while (n < fieldArray.length) {
                    this.m_boxes[n] = new JCheckBox(fieldArray[n].name, true);
                    this.m_boxes[n].addActionListener(this);
                    jPanel.add(this.m_boxes[n]);
                    ++n;
                }
            }

            public void setBorder(Border border) {
            }

            public void setEnabled(boolean bl) {
                int n = 0;
                while (n < this.m_boxes.length) {
                    this.m_boxes[n].setEnabled(bl);
                    ++n;
                }
            }

            boolean someSelected() {
                return this.m_nSelected > 0;
            }

            int[] selectedIndexes() {
                int[] nArray = new int[this.m_nSelected];
                int n = 0;
                int n2 = 0;
                while (n2 < this.m_boxes.length) {
                    if (this.m_boxes[n2].isSelected()) {
                        nArray[n++] = n2;
                    }
                    ++n2;
                }
                return nArray;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == EventAnalyzerPage.this.m_selectAll) {
                    int n = 0;
                    while (n < this.m_boxes.length) {
                        this.m_boxes[n].setSelected(true);
                        ++n;
                    }
                    this.m_nSelected = this.m_boxes.length;
                    return;
                }
                if (object == EventAnalyzerPage.this.m_selectNone) {
                    int n = 0;
                    while (n < this.m_boxes.length) {
                        this.m_boxes[n].setSelected(false);
                        ++n;
                    }
                    this.m_nSelected = 0;
                    return;
                }
                this.m_nSelected = ((AbstractButton)object).isSelected() ? ++this.m_nSelected : --this.m_nSelected;
            }
        }

        private final class NoDataSetsException
        extends Exception {
            private NoDataSetsException() {
            }
        }
    }

    private final class EventSourceSelectionPage
    extends JASWizardPage
    implements HasNextPages,
    HasHelpPage {
        private final Object m_initialEventSource;
        final ComboBoxModel m_model;
        private final JComboBox m_choicesBox;
        private EventAnalyzerPage m_nextPage;

        EventSourceSelectionPage(ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
            super(new FlowLayout());
            this.m_model = comboBoxModel;
            this.m_choicesBox = new JComboBox(comboBoxModel);
            this.m_choicesBox.setRenderer(listCellRenderer);
            this.add(new JLabel("Select the event source"));
            this.add(this.m_choicesBox);
            this.m_initialEventSource = comboBoxModel.getSelectedItem();
        }

        public JASWizardPage[] getNextWizardPages() {
            this.m_nextPage = new EventAnalyzerPage(true);
            JASWizardPage[] jASWizardPageArray = new JASWizardPage[]{this.m_nextPage};
            return jASWizardPageArray;
        }

        public JASWizardPage getNext() {
            NewProgramPage.access$1702(NewProgramPage.this, NewProgramPage.this.getFields(this.m_model, this.m_choicesBox.getSelectedIndex()));
            return this.m_nextPage;
        }

        public String getHelpTopic() {
            return "userInterface.programPageWizard.selectingAnEventSource";
        }

        public void onCancel() {
            if (this.m_model.getSelectedItem() != this.m_initialEventSource) {
                this.m_model.setSelectedItem(this.m_initialEventSource);
            }
        }
    }

    private final class EventGeneratorPage
    extends JASWizardPage
    implements Finishable,
    Previewable,
    HasHelpPage,
    ChangeListener {
        private boolean m_isValid;
        private PreviewButton m_previewButton;
        private JASTextField m_nameField;
        private JASTextField m_numberOfEventsField;
        private JASTextField m_fieldsField;
        private JLabel m_numberOfEventsLabel;
        private JCheckBox m_nEventsNotKnownBox;
        private JCheckBox m_haveSimpleEventDataClassBox;
        private JComboBox m_typesBox;
        private HistogramsPanel m_histPanel;
        private final String[] m_types_Descriptions = new String[]{"Double", "Int", "Date", "String"};
        private final String[] m_types_keywords = new String[]{"double", "int", "java.util.Date", "String"};
        private final String m_nEventsNotKnown_Key = "EventsNotKnown";
        private final String m_nEvents_Key = "nEvents";
        private final String m_haveSimpleClass_Key = "SimpleEventData";
        private final String m_dataType_Key = "DataType";

        EventGeneratorPage() {
            super(null);
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new JLabel("Enter a name for your event generator: "));
            this.m_nameField = new JASTextField(15);
            this.m_nameField.addKeyListener(this);
            jPanel.add(this.m_nameField);
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            this.m_numberOfEventsLabel = new JLabel("Enter number of events: ");
            jPanel2.add(this.m_numberOfEventsLabel);
            this.m_numberOfEventsField = new JASTextField(NewProgramPage.this.m_prop.getString("nEvents", null), 5);
            this.m_numberOfEventsField.addKeyListener(this);
            jPanel2.add(this.m_numberOfEventsField);
            boolean bl = NewProgramPage.this.m_prop.getBoolean("EventsNotKnown", false);
            this.m_nEventsNotKnownBox = new JCheckBox("Number of events not known", bl);
            this.m_nEventsNotKnownBox.setMnemonic('N');
            this.m_nEventsNotKnownBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ EventGeneratorPage this$1;
                {
                    this.this$1 = eventGeneratorPage;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = !EventGeneratorPage.access$400(this.this$1).isSelected();
                    EventGeneratorPage.access$500(this.this$1).setEnabled(bl);
                    EventGeneratorPage.access$500(this.this$1).repaint();
                    EventGeneratorPage.access$600(this.this$1).setEnabled(bl);
                    EventGeneratorPage.access$600(this.this$1).repaint();
                    this.this$1.doEnable();
                }
            });
            this.m_numberOfEventsField.setEnabled(!bl);
            this.m_numberOfEventsLabel.setEnabled(!bl);
            jPanel2.add(this.m_nEventsNotKnownBox);
            JPanel jPanel3 = new JPanel(null);
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            this.m_haveSimpleEventDataClassBox = new JCheckBox("Create a simple NTupleEventData class", NewProgramPage.this.m_prop.getBoolean("SimpleEventData", true));
            this.m_haveSimpleEventDataClassBox.addChangeListener(this);
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            JLabel jLabel = new JLabel("Enter the fields for each event: ");
            jPanel4.add(jLabel);
            this.m_fieldsField = new JASTextField(15);
            this.m_fieldsField.addKeyListener(this);
            jPanel4.add(this.m_fieldsField);
            JPanel jPanel5 = new JPanel(new FlowLayout(0));
            JLabel jLabel2 = new JLabel("Select the type for your data: ");
            this.m_typesBox = new JComboBox<String>(this.m_types_Descriptions);
            this.m_typesBox.setSelectedIndex(NewProgramPage.this.m_prop.getInteger("DataType", 0));
            this.m_haveSimpleEventDataClassBox.addActionListener(new ActionListener(this, jLabel, jLabel2){
                private final /* synthetic */ JLabel val$fieldsLabel;
                private final /* synthetic */ JLabel val$typesLabel;
                private final /* synthetic */ EventGeneratorPage this$1;
                {
                    this.this$1 = eventGeneratorPage;
                    this.val$fieldsLabel = jLabel;
                    this.val$typesLabel = jLabel2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = EventGeneratorPage.access$700(this.this$1).isSelected();
                    this.val$fieldsLabel.setEnabled(bl);
                    this.val$fieldsLabel.repaint();
                    EventGeneratorPage.access$800(this.this$1).setEnabled(bl);
                    EventGeneratorPage.access$800(this.this$1).repaint();
                    this.val$typesLabel.setEnabled(bl);
                    this.val$typesLabel.repaint();
                    EventGeneratorPage.access$900(this.this$1).setEnabled(bl);
                    EventGeneratorPage.access$900(this.this$1).repaint();
                }
            });
            boolean bl2 = this.m_haveSimpleEventDataClassBox.isSelected();
            jLabel.setEnabled(bl2);
            this.m_fieldsField.setEnabled(bl2);
            jLabel2.setEnabled(bl2);
            this.m_typesBox.setEnabled(bl2);
            jPanel5.add(jLabel2);
            jPanel5.add(this.m_typesBox);
            JPanel jPanel6 = new JPanel(new FlowLayout(0));
            jPanel6.add(this.m_haveSimpleEventDataClassBox);
            jPanel3.add(jPanel6);
            jPanel3.add(jPanel4);
            jPanel3.add(jPanel5);
            jPanel3.setBorder(BorderFactory.createEtchedBorder());
            JPanel jPanel7 = new JPanel();
            JButton jButton = new JButton("Edit list of Cuts");
            jButton.addActionListener(NewProgramPage.this.m_cutsManager);
            jButton.setEnabled(false);
            jPanel7.add(jButton);
            this.m_previewButton = new PreviewButton(this, this);
            jPanel7.add(this.m_previewButton);
            this.add(jPanel);
            this.add(jPanel2);
            this.m_histPanel = new HistogramsPanel();
            this.add(this.m_histPanel);
            this.add(jPanel3);
            this.add(jPanel7);
        }

        public String getHelpTopic() {
            return "userInterface.programPageWizard.eventGeneratorPage";
        }

        private boolean isCorrectIntegerFormat(String string) {
            try {
                if (Integer.parseInt(string) <= 0) {
                    JOptionPane.showMessageDialog(this, "You must enter a positive number.", "Error", 0);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, string.concat(" is not an integer."), "Number Format Exception", 0);
                return false;
            }
            return true;
        }

        public void onFinish() {
            String string = this.generateText();
            if (string != null) {
                boolean bl = this.m_nEventsNotKnownBox.isSelected();
                NewProgramPage.this.m_prop.setBoolean("EventsNotKnown", bl);
                if (!bl) {
                    NewProgramPage.this.m_prop.setString("nEvents", this.m_numberOfEventsField.getText());
                }
                NewProgramPage.this.m_prop.setBoolean("SimpleEventData", this.m_haveSimpleEventDataClassBox.isSelected());
                NewProgramPage.this.m_prop.setInteger("DataType", this.m_typesBox.getSelectedIndex());
                NewProgramPage.this.finish(string);
            }
        }

        public String generateText() {
            IdentifierMonitor identifierMonitor = new IdentifierMonitor();
            try {
                String string;
                boolean bl = !this.m_nEventsNotKnownBox.isSelected();
                boolean bl2 = this.m_haveSimpleEventDataClassBox.isSelected();
                String string2 = this.m_numberOfEventsField.getText();
                if (bl && !this.isCorrectIntegerFormat(string2)) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer(400);
                NewProgramPage.this.addOpening(stringBuffer);
                stringBuffer.append("import hep.analysis.*;\nfinal public class " + NewProgramPage.this.m_className + " extends EventGenerator\n{\n");
                boolean bl3 = NewProgramPage.this.declareDataViews(stringBuffer, this.m_histPanel, identifierMonitor);
                NewProgramPage.this.declareCuts(stringBuffer, identifierMonitor);
                int n = 0;
                int n2 = this.m_typesBox.getSelectedIndex();
                StringTokenizer stringTokenizer = new StringTokenizer(this.m_fieldsField.getText());
                if (bl2) {
                    String string3;
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken() + "_FieldIndex";
                        identifierMonitor.registerWizardIdentifier(string3);
                        stringBuffer.append("\tfinal private int " + string3 + " = " + n++ + ";\n");
                    }
                    stringBuffer.append("\tfinal private int nFields = " + n + ";\n" + "\t" + "final private java.util.Hashtable " + "hash" + " = new java.util.Hashtable(nFields, 1f);\n\n");
                    identifierMonitor.registerWizardIdentifier("nFields");
                    identifierMonitor.registerWizardIdentifier("hash");
                    stringTokenizer = new StringTokenizer(this.m_fieldsField.getText());
                    string3 = stringTokenizer.nextToken();
                    identifierMonitor.registerUserIdentifier(string3);
                    stringBuffer.append("\tprivate " + this.m_types_keywords[n2] + " " + string3);
                    while (stringTokenizer.hasMoreElements()) {
                        string3 = stringTokenizer.nextToken();
                        identifierMonitor.registerUserIdentifier(string3);
                        stringBuffer.append(", " + string3);
                    }
                    stringBuffer.append(";\n\n");
                }
                if (bl) {
                    stringBuffer.append("\tfinal private int nEvents = " + string2 + ";\n" + "\t" + "private int " + "currentEvent" + " = 0;\n\n");
                    identifierMonitor.registerWizardIdentifier("nEvents");
                    identifierMonitor.registerWizardIdentifier("currentEvent");
                }
                stringBuffer.append("\tpublic " + NewProgramPage.this.m_className + "()\n" + "\t" + "{\n");
                stringTokenizer = new StringTokenizer(this.m_fieldsField.getText());
                if (bl2) {
                    while (stringTokenizer.hasMoreElements()) {
                        string = stringTokenizer.nextToken();
                        stringBuffer.append("\t\thash.put(\"" + string + "\", new Integer(" + string + "_FieldIndex));\n");
                    }
                }
                string = "// Enter" + (bl2 ? " other" : "") + " constructor code here.\n";
                if (bl2) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append("\t\t" + string + "\t" + "}\n" + "\t" + "public void beforeFirstEvent()\n" + "\t" + "{\n");
                if (bl) {
                    stringBuffer.append("\t\t" + "currentEvent".concat(" = 0; // reset counter\n"));
                }
                if (!bl) {
                    stringBuffer.append("\t\t// Enter code here or delete method definition.\n");
                }
                stringBuffer.append("\t}\n\tpublic void afterLastEvent()\n\t{\n\t\t// Enter code here or delete method definition.\n\t}\n\tpublic void close()\n\t{\n\t\t// Enter code here or delete method definition.\n\t}\n\tpublic Class getEventDataClass()\n\t{\n\t\t" + (bl2 ? "return SimpleEventData.class;" : "// Return a Class object here.") + '\n' + "\t" + "}\n" + "\t" + "public EventData generateEvent() throws EndOfDataException\n" + "\t" + "{\n" + "\t" + "\t");
                if (bl) {
                    stringBuffer.append("if (currentEvent++ >= nEvents) throw new EndOfDataException();\n\n");
                } else {
                    stringBuffer.append("// Be sure to throw an EndOfDataException when you are done.\n\n");
                }
                stringTokenizer = new StringTokenizer(this.m_fieldsField.getText());
                if (bl2) {
                    while (stringTokenizer.hasMoreElements()) {
                        stringBuffer.append("\t\t" + stringTokenizer.nextElement() + " = ; // Enter calculation for this field here.\n");
                    }
                    stringBuffer.append('\n');
                }
                NewProgramPage.this.fillDataViews(stringBuffer, this.m_histPanel);
                if (bl2) {
                    stringBuffer.append("\n\t\tfinal SimpleEventData eventData = new SimpleEventData();\n");
                    identifierMonitor.registerWizardIdentifier("eventData");
                    identifierMonitor.registerClass("SimpleEventData");
                    stringTokenizer = new StringTokenizer(this.m_fieldsField.getText());
                    if (bl2) {
                        while (stringTokenizer.hasMoreElements()) {
                            String string4 = stringTokenizer.nextToken();
                            stringBuffer.append("\t\teventData.data[" + string4 + "_FieldIndex] = " + string4 + ";\n");
                        }
                    }
                    stringBuffer.append("\t\treturn eventData;\n");
                } else {
                    stringBuffer.append("\t\t// Create and return EventData object here.\n");
                }
                stringBuffer.append("\t}\n\tpublic String getName()\n\t{\n\t\treturn \"" + this.m_nameField.getText() + "\";\n" + "\t" + "}\n");
                if (bl) {
                    stringBuffer.append("\tpublic int getTotalNumberOfEvents()\n\t{\n\t\treturn nEvents;\n\t}\n");
                }
                if (bl2) {
                    stringBuffer.append("\tfinal private class SimpleEventData extends AbstractNTupleEventData\n\t{\n\t\tfinal " + this.m_types_keywords[n2] + "[] data = " + "new " + this.m_types_keywords[n2] + "[nFields];\n" + '\n' + "\t" + "\t" + "// Note that this method is deprecated and may\n" + "\t" + "\t" + "// generate a compiler warning.  It is included\n" + "\t" + "\t" + "// for completeness, but is much slower\n" + "\t" + "\t" + "// than get" + this.m_types_Descriptions[n2] + "(int).\n" + "\t" + "\t" + "// The definition may be deleted.\n" + "\t" + "\t" + "public " + this.m_types_keywords[n2] + " get" + this.m_types_Descriptions[n2] + "(final String name)\n" + "\t" + "\t" + "{\n" + "\t" + "\t" + "\t" + "return data[findColumn(name)];\n" + "\t" + "\t" + "}\n" + "\t" + "\t" + "public " + this.m_types_keywords[n2] + " get" + this.m_types_Descriptions[n2] + "(final int column)\n" + "\t" + "\t" + "{\n" + "\t" + "\t" + "\t" + "return data[column];\n" + "\t" + "\t" + "}\n" + "\t" + "\t" + "public int findColumn(final String name)\n" + "\t" + "\t" + "{\n" + "\t" + "\t" + "\t" + "return ((Integer) hash.get(name)).intValue();\n" + "\t" + "\t" + "}\n" + "\t" + "}\n");
                }
                stringBuffer.append("}");
                return stringBuffer.toString();
            }
            catch (IdentifierException identifierException) {
                return null;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.doEnable();
        }

        protected void doEnable() {
            String string;
            int n;
            boolean bl = this.m_isValid = (this.m_nEventsNotKnownBox.isSelected() || this.m_numberOfEventsField.getText().length() > 0) && this.m_nameField.getText().length() > 0;
            if (this.m_isValid && this.m_haveSimpleEventDataClassBox.isSelected() && (this.m_isValid &= (n = (string = this.m_fieldsField.getText()).length()) > 0)) {
                int n2 = 0;
                while (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                    if (++n2 < n) continue;
                    this.m_isValid = false;
                    break;
                }
            }
            this.m_previewButton.setEnabled(this.m_isValid);
            super.doEnable();
        }

        protected boolean getFinishEnabled() {
            return this.m_isValid;
        }

        public void beforeShowing() {
            this.m_nameField.setText(NewProgramPage.this.m_className);
            this.doEnable();
        }

        static /* synthetic */ JCheckBox access$400(EventGeneratorPage eventGeneratorPage) {
            return eventGeneratorPage.m_nEventsNotKnownBox;
        }

        static /* synthetic */ JASTextField access$500(EventGeneratorPage eventGeneratorPage) {
            return eventGeneratorPage.m_numberOfEventsField;
        }

        static /* synthetic */ JLabel access$600(EventGeneratorPage eventGeneratorPage) {
            return eventGeneratorPage.m_numberOfEventsLabel;
        }

        static /* synthetic */ JCheckBox access$700(EventGeneratorPage eventGeneratorPage) {
            return eventGeneratorPage.m_haveSimpleEventDataClassBox;
        }

        static /* synthetic */ JASTextField access$800(EventGeneratorPage eventGeneratorPage) {
            return eventGeneratorPage.m_fieldsField;
        }

        static /* synthetic */ JComboBox access$900(EventGeneratorPage eventGeneratorPage) {
            return eventGeneratorPage.m_typesBox;
        }
    }

    private final class IdentifierMonitor {
        private final Vector m_classes = new Vector();
        private final Vector m_wizard = new Vector();
        private final Vector m_user = new Vector();
        private final Vector m_misc = new Vector();

        private IdentifierMonitor() {
        }

        private boolean isClassName(String string) {
            try {
                Class.forName(string);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Class.forName("java.lang." + string);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    try {
                        Class.forName("hep.analysis." + string);
                        return true;
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        return string.equals(NewProgramPage.this.m_className) || this.m_classes.contains(string);
                    }
                }
            }
        }

        private void isConflict(String string) {
            JOptionPane.showMessageDialog(NewProgramPage.this, "You cannot use the identifier \"" + string + "\" for a field\n" + "because the wizard needs to use it.", "Error", 0);
        }

        void registerClass(String string) throws IdentifierException {
            if (!NewProgramPage.this.isLegalIdentifier(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create a class\nthat is not a legal identifier: " + string, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_classes.contains(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create two classes\nwith the same name: " + string, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_wizard.contains(string) || this.m_misc.contains(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create a class\nwith the same name as an identifier: " + string, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_user.contains(string)) {
                this.isConflict(string);
                throw new IdentifierException();
            }
            this.m_classes.addElement(string);
        }

        void registerWizardIdentifier(String string) throws IdentifierException {
            if (!NewProgramPage.this.isLegalIdentifier(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create an identifier\nthat is not legal: " + string, "Error", 0);
                throw new IdentifierException();
            }
            if (this.isClassName(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create an identifier\nwith the same name as a class: " + string, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_wizard.contains(string) || this.m_misc.contains(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create two identifiers\nwith the same name: " + string, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_user.contains(string)) {
                this.isConflict(string);
                throw new IdentifierException();
            }
            this.m_wizard.addElement(string);
        }

        void registerUserIdentifier(String string) throws IdentifierException {
            if (!NewProgramPage.this.isLegalIdentifier(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, string.concat(" is not a legal identifier."), "Error", 0);
                throw new IdentifierException();
            }
            if (this.isClassName(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "You cannot create a field with the name\n\"" + string + "\" because it is a class name.", "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_user.contains(string)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "You cannot have two fields\nwith the same name: " + string, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_wizard.contains(string) || this.m_misc.contains(string)) {
                this.isConflict(string);
                throw new IdentifierException();
            }
            this.m_user.addElement(string);
        }
    }

    private final class IdentifierException
    extends Exception {
        private IdentifierException() {
        }
    }

    private static final class Field {
        final String name;
        final String type;

        Field(String string, String string2) {
            this.name = string;
            this.type = string2;
        }
    }
}

