/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.JASAddRemovePanel;
import jas.swingstudio.JASList;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.Application;
import jas.util.UserProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class MultiFilePanel
extends JPanel {
    private final UserProperties m_prop = Application.getApplication().getUserProperties();
    private FileAddRemovePanel ar;
    private JButton save;
    private JButton restore;
    private JButton clear;
    private String description;
    private String borderText;
    private FileFilter filter;
    private String key;
    private FileList fileList;

    public MultiFilePanel(FileFilter fileFilter, String string, String string2, String string3) {
        this.filter = fileFilter;
        this.description = string;
        this.borderText = string2;
        this.key = string3;
        this.fileList = new FileList();
        this.setLayout(new BorderLayout());
        this.ar = new FileAddRemovePanel(this.fileList, string, string2);
        this.add((Component)this.ar, "Center");
        this.clear = new JButton("Clear File Set");
        this.save = new JButton("Save File Set...");
        this.restore = new JButton("Restore File Set...");
        this.clear.addActionListener(this.ar);
        this.save.addActionListener(this.ar);
        this.restore.addActionListener(this.ar);
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.add(this.clear);
        jPanel.add(this.save);
        jPanel.add(this.restore);
        this.add((Component)jPanel, "East");
    }

    public int getNFiles() {
        this.ar.update();
        return this.fileList.getSize();
    }

    public String getFilePath() {
        this.ar.update();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.fileList.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
            if (!enumeration.hasMoreElements()) break;
            stringBuffer.append(File.pathSeparatorChar);
        }
        return stringBuffer.toString();
    }

    public void saveState() {
        this.ar.update();
        String[] stringArray = new String[this.fileList.getSize()];
        Enumeration enumeration = this.fileList.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = enumeration.nextElement().toString();
            ++n;
        }
        this.m_prop.setStringArray(this.key, stringArray);
    }

    final class FileListFileFilter
    extends FileFilter {
        FileListFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".filelist");
        }

        public String getDescription() {
            return "File List (*.filelist)";
        }
    }

    private class FileAddRemovePanel
    extends JASAddRemovePanel {
        FileAddRemovePanel(FileList fileList, String string, String string2) {
            super(fileList, string, string2, "Select New Files");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = MultiFilePanel.this.m_prop.getString(MultiFilePanel.this.key + ".dir", ".");
                Object object = actionEvent.getSource();
                if (object == MultiFilePanel.this.save) {
                    JFileChooser jFileChooser = new JFileChooser(string);
                    jFileChooser.setDialogTitle("Save File Set ...");
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileFilter(new FileListFileFilter());
                    if (jFileChooser.showSaveDialog(MultiFilePanel.this) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        if (file.getName().indexOf(".") < 0) {
                            file = new File(file.getAbsolutePath() + ".filelist");
                        }
                        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                        this.update();
                        Enumeration enumeration = MultiFilePanel.this.fileList.elements();
                        while (enumeration.hasMoreElements()) {
                            printWriter.println(enumeration.nextElement().toString());
                        }
                        printWriter.close();
                        MultiFilePanel.this.m_prop.setString(MultiFilePanel.this.key + ".dir", file.toString());
                    }
                } else if (object == MultiFilePanel.this.restore) {
                    JFileChooser jFileChooser = new JFileChooser(string);
                    jFileChooser.setDialogTitle("Restore File Set ...");
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileFilter(new FileListFileFilter());
                    if (jFileChooser.showOpenDialog(MultiFilePanel.this) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
                        Vector<File> vector = new Vector<File>();
                        String string2 = lineNumberReader.readLine();
                        while (string2 != null) {
                            vector.addElement(new File(string2));
                            string2 = lineNumberReader.readLine();
                        }
                        lineNumberReader.close();
                        MultiFilePanel.this.fileList.setContents(vector);
                        this.setModel(MultiFilePanel.this.fileList);
                        MultiFilePanel.this.m_prop.setString(MultiFilePanel.this.key + ".dir", file.toString());
                    }
                } else if (object == MultiFilePanel.this.clear) {
                    MultiFilePanel.this.fileList.setContents(new Vector());
                    this.setModel(MultiFilePanel.this.fileList);
                } else {
                    super.actionPerformed(actionEvent);
                }
            }
            catch (IOException iOException) {
                JavaAnalysisStudio.getApp().error("Error saving or restoring file set", iOException);
            }
        }

        protected Object add(String string) {
            String string2 = MultiFilePanel.this.m_prop.getString(MultiFilePanel.this.key + ".dir", ".");
            JFileChooser jFileChooser = new JFileChooser(string2);
            jFileChooser.setDialogTitle("Files to add to dataset");
            jFileChooser.setFileFilter(MultiFilePanel.this.filter);
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showDialog(this, "Add");
            if (n != 0) {
                return null;
            }
            File file = jFileChooser.getSelectedFile();
            MultiFilePanel.this.m_prop.setString(MultiFilePanel.this.key + ".dir", file.toString());
            return file;
        }
    }

    private class FileList
    implements JASList {
        private Vector v = new Vector();

        FileList() {
            String[] stringArray = MultiFilePanel.this.m_prop.getStringArray(MultiFilePanel.this.key, null);
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    this.v.addElement(new File(stringArray[n]));
                    ++n;
                }
            }
        }

        public Enumeration elements() {
            return this.v.elements();
        }

        public void setContents(Vector vector) {
            this.v = vector;
        }

        int getSize() {
            return this.v.size();
        }
    }
}

