/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.JASClassPathDialog;
import jas.util.Application;
import jas.util.JASDialog;
import jas.util.JASEditableComboBox;
import jas.util.JASState;
import jas.util.UserProperties;
import jas.util.WrappingTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class LoadDialog
extends JASDialog
implements ChangeListener {
    static final String length_Key = "MaxClassesLength";
    private static final String m_message = "Specify the class name of your Java analysis routine (e.g. MyAnalysis or slac.sld.Recon). The class must extend hep.analysis.EventAnalyzer or hep.analysis.EventGenerator and must be in your current JAS_CLASSPATH.";
    private JASEditableComboBox m_classes;
    private String m_text;
    private JFrame m_frame;
    private String[] m_lastClasses;
    private static final String m_lastClasses_Key = "LastClasses";

    LoadDialog(JFrame jFrame) {
        this(jFrame, m_message, m_lastClasses_Key);
    }

    protected LoadDialog(JFrame jFrame, String string, String string2) {
        super((Frame)jFrame, "Load...", true, 13);
        this.m_frame = jFrame;
        WrappingTextArea wrappingTextArea = new WrappingTextArea(string, false, ((Component)this).getBackground(), new Dimension(340, 75));
        Container container = this.getContentPane();
        container.add((Component)wrappingTextArea, "South");
        this.m_classes = new JASEditableComboBox(string2, length_Key, true);
        JButton jButton = new JButton("Set Class Path ...");
        jButton.addActionListener(new ShowClassPath());
        container.add((Component)new JLabel("Class: "), "West");
        container.add((Component)this.m_classes, "Center");
        container.add((Component)jButton, "East");
        this.m_classes.addChangeListener(this);
        this.setHelpTopic("jobs.eventAnalysisAndGeneration.loadingClasses");
        this.pack();
    }

    protected void onOK() {
        this.m_text = this.getText();
        this.m_classes.saveState();
        super.onOK();
    }

    protected void enableOK(JASState jASState) {
        jASState.setEnabled(this.getText().length() > 0);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.callEnable();
    }

    String getClassName() {
        return this.m_text;
    }

    private String getText() {
        return this.m_classes.getText();
    }

    static void updateListWithClass(String string) {
        UserProperties userProperties = Application.getApplication().getUserProperties();
        userProperties.setStringArray(m_lastClasses_Key, userProperties.updateStringArray(userProperties.getStringArray(m_lastClasses_Key, null), string, length_Key));
    }

    private class ShowClassPath
    implements ActionListener {
        private ShowClassPath() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JASClassPathDialog jASClassPathDialog = new JASClassPathDialog(LoadDialog.this.m_frame);
            jASClassPathDialog.doModal();
        }
    }
}

