/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.jds.interfaces.JavaDataServer;
import jas.swingstudio.JASJob;
import jas.swingstudio.JASJobAdaptor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.Finishable;
import jas.util.HasHelpPage;
import jas.util.JASWizardPage;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

class ListJobPage
extends JASWizardPage
implements Finishable,
HasHelpPage {
    private JavaDataServer m_jds;
    private JTable m_table;
    private String[][] m_data;
    private JScrollPane m_scroll;
    private JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();

    ListJobPage() {
        super(new BorderLayout());
        this.add("North", new JLabel("Select job to connect to:"));
        this.m_table = new JTable();
        this.m_table.setAutoResizeMode(0);
        this.m_scroll = new JScrollPane(this.m_table);
        this.m_scroll.setPreferredSize(new Dimension(300, 150));
        this.add("Center", this.m_scroll);
    }

    public void setJDS(JavaDataServer javaDataServer) throws RemoteException {
        this.m_jds = javaDataServer;
        String[] stringArray = javaDataServer.listJobs();
        this.m_data = new String[stringArray.length][];
        int n = 0;
        while (n < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "\\");
            String[] stringArray2 = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray2[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            this.m_data[n] = stringArray2;
            ++n;
        }
    }

    public void beforeShowing() {
        this.m_table.setModel(new AbstractTableModel(){

            public int getRowCount() {
                return ListJobPage.this.m_data.length - 1;
            }

            public int getColumnCount() {
                return ListJobPage.this.m_data[0].length;
            }

            public Object getValueAt(int n, int n2) {
                return ListJobPage.this.m_data[n + 1][n2];
            }

            public String getColumnName(int n) {
                return ListJobPage.this.m_data[0][n];
            }
        });
        this.m_table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JButton jButton;
                if (mouseEvent.getClickCount() == 2 && (jButton = ListJobPage.this.getRootPane().getDefaultButton()) != null) {
                    jButton.doClick();
                }
            }
        });
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListJobPage.this.doEnable();
            }
        });
    }

    protected void doEnable() {
        super.doEnable();
    }

    protected boolean getFinishEnabled() {
        return !this.m_table.getSelectionModel().isSelectionEmpty();
    }

    public String getHelpTopic() {
        return "Connect";
    }

    public void onFinish() {
        int n = this.m_table.getSelectionModel().getLeadSelectionIndex();
        String string = this.m_data[n + 1][0];
        String string2 = this.m_data[n + 1][1];
        JASJob jASJob = new JASJob(string2);
        try {
            JASJobAdaptor jASJobAdaptor = new JASJobAdaptor(jASJob, string, this.m_jds, this);
            this.m_app.closeCurrentJob();
            jASJob.setJob(jASJobAdaptor);
            this.m_app.setJob(jASJob, true);
            jASJobAdaptor.listItems();
            this.dispose();
        }
        catch (Exception exception) {
            this.m_app.error("Could not connect to job", exception);
        }
    }
}

