/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.hist.FunctionFactory;
import jas.swingstudio.FitterListModel;
import jas.swingstudio.FunctionListModel;
import jas.swingstudio.LocalDIMListModel;
import jas.swingstudio.OptionsAddRemovePanel;
import jas.swingstudio.OptionsDialog;
import jas.swingstudio.OptionsPage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

final class JASRegistryDialog
extends OptionsDialog {
    JASRegistryDialog(Frame frame) {
        super(frame, "Registries...");
        this.addPage("Function registry", new Functions());
        this.addPage("Fitter registry", new Fitters());
        this.addPage("Local DIM registry", new DIMs());
        this.pack();
        this.m_init = true;
        this.show();
    }

    private final class DIMs
    extends OptionsPage {
        private OptionsAddRemovePanel panel = new OptionsAddRemovePanel(new LocalDIMListModel(), "Local DIMs in registry", "Local DIM registry");

        DIMs() {
            super(new GridLayout(1, 1));
            this.panel.addListDataListener(JASRegistryDialog.this);
            this.add(this.panel);
        }

        void apply() {
            this.panel.update();
        }

        String getHelpTopic() {
            return "functionsAndFilters.registries";
        }
    }

    private final class Fitters
    extends OptionsPage {
        private OptionsAddRemovePanel panel = new OptionsAddRemovePanel(new FitterListModel(), "Fitters in fitter registry", "Fitter registry");

        Fitters() {
            super(new GridLayout(1, 1));
            this.panel.addListDataListener(JASRegistryDialog.this);
            this.add(this.panel);
        }

        void apply() {
            this.panel.update();
        }

        String getHelpTopic() {
            return "functionsAndFilters.registries";
        }
    }

    private final class Functions
    extends OptionsPage {
        private OptionsAddRemovePanel panel = new OptionsAddRemovePanel(new FunctionListModel(), "Function in function registry", "Function registry", new DataRenderer());

        Functions() {
            super(new GridLayout(1, 1));
            this.panel.addListDataListener(JASRegistryDialog.this);
            this.add(this.panel);
        }

        void apply() {
            this.panel.update();
        }

        String getHelpTopic() {
            return "functionsAndFilters.registries";
        }

        private final class DataRenderer
        extends DefaultListCellRenderer {
            private DataRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = object instanceof FunctionFactory ? ((FunctionFactory)object).getFunctionName() : object.toString();
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        }
    }
}

